/*
 * Decompiled with CFR 0.152.
 */
package io.codeworth.panelmatic.impl.gridbagpanelbuilder;

import io.codeworth.panelmatic.componentbehavior.ComponentBehavior;
import io.codeworth.panelmatic.impl.AbstractPanelBuilder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;

public class GbPanelBuilder
extends AbstractPanelBuilder {
    private GridBagConstraints labelConstraints = new GridBagConstraints();
    private GridBagConstraints headerConstraints;
    private JComponent product = null;
    private static final int[][] ANCHORS = new int[][]{{23, 19, 24}, {21, 10, 22}, {25, 20, 26}};
    private static final int[][] FILLS = new int[][]{{0, 2}, {3, 1}};

    public GbPanelBuilder() {
        this.labelConstraints.insets = new Insets(1, 1, 1, 1);
        this.labelConstraints.anchor = 21;
    }

    @Override
    public void setHeaderBehavior(ComponentBehavior aHeaderBehavior) {
        super.setHeaderBehavior(aHeaderBehavior);
        this.headerConstraints = this.convertBehavior(this.getHeaderBehavior());
        this.headerConstraints.gridwidth = 0;
    }

    @Override
    public void setLabelBehavior(ComponentBehavior aLabelBehavior) {
        super.setLabelBehavior(aLabelBehavior);
        this.labelConstraints = this.convertBehavior(this.getLabelBehavior());
    }

    @Override
    protected void beginImpl(JComponent aBaseComp) {
        this.product = aBaseComp;
        this.product.setLayout(new GridBagLayout());
    }

    @Override
    protected void addHeaderImpl(JComponent aHeaderComp) {
        this.product.add((Component)aHeaderComp, this.headerConstraints);
    }

    @Override
    protected void addImpl(JComponent aLabelComp, JComponent aComp, ComponentBehavior aBehavior) {
        if (aLabelComp != null) {
            this.product.add((Component)aLabelComp, this.labelConstraints);
        }
        GridBagConstraints compCons = this.convertBehavior(aBehavior);
        compCons.gridwidth = 0;
        compCons.weightx = 1.0;
        this.product.add((Component)aComp, compCons);
    }

    @Override
    protected JComponent getImpl() {
        JComponent p = this.product;
        this.product = null;
        return p;
    }

    protected GridBagConstraints convertBehavior(ComponentBehavior b) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = b.getInsets();
        gbc.anchor = ANCHORS[b.getPageAlign().ordinal()][b.getLineAlign().ordinal()];
        gbc.weighty = b.getPageGrowFactor();
        gbc.fill = FILLS[b.isPageStretch() ? 1 : 0][b.isLineStretch() ? 1 : 0];
        return gbc;
    }

    protected JComponent getProduct() {
        return this.product;
    }
}

