/*
 * Decompiled with CFR 0.152.
 */
package io.codeworth.panelmatic.impl;

import io.codeworth.panelmatic.PanelBuilder;
import io.codeworth.panelmatic.PanelBuilderComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DefaultComponentFactory
implements PanelBuilderComponentFactory {
    private ComponentOrientation componentOrientation = ComponentOrientation.LEFT_TO_RIGHT;

    @Override
    public JComponent getComponentLabel(Icon icon, String text, JComponent component) {
        JLabel lbl = this.orient(new JLabel(text, icon, 10));
        lbl.setLabelFor(component);
        return lbl;
    }

    @Override
    public JComponent getHeader(PanelBuilder.HeaderLevel hx, Icon icon, String text, JComponent ... items) {
        JComponent retval = this.createHeaderLabel(text, icon, hx);
        if (items.length == 1) {
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)retval, "Center");
            p.add((Component)items[0], "After");
            retval = p;
        } else {
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)retval, "Center");
            Box compBox = Box.createHorizontalBox();
            for (JComponent item : items) {
                compBox.add(item);
            }
            p.add((Component)compBox, "After");
            retval = p;
        }
        return this.orient(retval);
    }

    protected JLabel createHeaderLabel(String text, Icon icon, PanelBuilder.HeaderLevel hx) {
        JLabel l = new JLabel(text, icon, 10);
        int valueCount = PanelBuilder.HeaderLevel.values().length;
        double emFactor = 1.0 - (double)hx.ordinal() / (double)valueCount;
        emFactor = 0.7 + emFactor * 1.3;
        Font f = l.getFont();
        int fontStyle = 1;
        if (hx.ordinal() % 2 == 0) {
            fontStyle |= 2;
        }
        l.setFont(f.deriveFont(fontStyle, (int)((double)f.getSize() * emFactor)));
        return this.orient(l);
    }

    @Override
    public JComponent getContainer() {
        JPanel pnl = new JPanel();
        pnl.setOpaque(false);
        return this.orient(pnl);
    }

    protected <T extends JComponent> T orient(T comp) {
        comp.setComponentOrientation(this.componentOrientation);
        return comp;
    }

    @Override
    public ComponentOrientation getComponentOrientation() {
        return this.componentOrientation;
    }

    @Override
    public void setComponentOrientation(ComponentOrientation aComponentOrientation) {
        this.componentOrientation = aComponentOrientation;
    }
}

