/*
 * Decompiled with CFR 0.152.
 */
package io.codeworth.panelmatic.impl;

import io.codeworth.panelmatic.BuilderPool;
import io.codeworth.panelmatic.PanelBuilder;
import io.codeworth.panelmatic.PanelBuilderComponentFactory;
import io.codeworth.panelmatic.PanelMaticComponentCustomizer;
import io.codeworth.panelmatic.PanelPostProcessor;
import io.codeworth.panelmatic.componentbehavior.BehaviorBuilder;
import io.codeworth.panelmatic.componentbehavior.BehaviorModifier;
import io.codeworth.panelmatic.componentbehavior.ComponentBehavior;
import io.codeworth.panelmatic.componentbehavior.LineAlign;
import io.codeworth.panelmatic.componentbehavior.Modifiers;
import io.codeworth.panelmatic.impl.DefaultComponentFactory;
import io.codeworth.panelmatic.impl.FlexibleSpaceComp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class AbstractPanelBuilder
implements PanelBuilder {
    private PanelBuilderComponentFactory componentFactory = new DefaultComponentFactory();
    private List<PanelMaticComponentCustomizer> currentBuildCustomizers = null;
    private List<PanelMaticComponentCustomizer> customizerChain = new ArrayList<PanelMaticComponentCustomizer>();
    private ComponentBehavior baseComponentBehavior;
    private ComponentBehavior headerBehavior;
    private ComponentBehavior labelBehavior;
    private BuilderPool myPool;
    private ResourceBundle resourceBundle;

    public AbstractPanelBuilder(ComponentBehavior headerBehavior, ComponentBehavior labelBehavior, ComponentBehavior baseComponentBehavior) {
        this.baseComponentBehavior = baseComponentBehavior;
        this.headerBehavior = headerBehavior;
        this.labelBehavior = labelBehavior;
    }

    public AbstractPanelBuilder(ComponentBehavior baseComponentBehavior) {
        this(new BehaviorBuilder().lineAlign(LineAlign.CENTER).lineStretch(true).get(), new BehaviorBuilder().lineAlign(LineAlign.START).lineStretch(false).insets(1, 1, 1, 5).get(), baseComponentBehavior);
    }

    public AbstractPanelBuilder() {
        this(new BehaviorBuilder().start().lineAlign(LineAlign.START).lineStretch(true).pageStretch(true).insets(1, 1, 3, 1).get());
    }

    @Override
    public PanelBuilder begin(PanelMaticComponentCustomizer ... custsForCurrentBuild) {
        return this.begin(this.componentFactory.getContainer(), custsForCurrentBuild);
    }

    @Override
    public PanelBuilder begin(JComponent basePanel, PanelMaticComponentCustomizer ... custsForCurrentBuild) {
        if (custsForCurrentBuild.length > 0) {
            this.currentBuildCustomizers = Arrays.asList(custsForCurrentBuild);
        }
        basePanel.setComponentOrientation(this.componentFactory.getComponentOrientation());
        this.beginImpl(basePanel);
        return this;
    }

    @Override
    public PanelBuilder addHeader(PanelBuilder.HeaderLevel hx, String title, JComponent ... comps) {
        return this.addHeader(hx, null, title, comps);
    }

    @Override
    public PanelBuilder addHeader(PanelBuilder.HeaderLevel hx, Icon icn, String title, JComponent ... comps) {
        JComponent hdr = this.componentFactory.getHeader(hx, icn, this.getResourceString(title), comps);
        this.addHeaderImpl(hdr);
        return this;
    }

    @Override
    public PanelBuilder add(String title, JComponent comp, BehaviorModifier ... modifiers) {
        return this.add(null, title, comp, modifiers);
    }

    @Override
    public PanelBuilder add(Icon icn, String title, JComponent comp, BehaviorModifier ... modifiers) {
        return this.add(this.componentFactory.getComponentLabel(icn, this.getResourceString(title), comp), comp, modifiers);
    }

    @Override
    public PanelBuilder add(JComponent comp, BehaviorModifier ... modifiers) {
        return this.add((JComponent)null, comp, modifiers);
    }

    @Override
    public PanelBuilder add(JComponent labelComp, JComponent comp, BehaviorModifier ... modifiers) {
        return this.add(null, labelComp, comp, modifiers);
    }

    protected PanelBuilder add(String labelText, JComponent labelComp, JComponent aComp, BehaviorModifier ... modifiers) {
        JComponent comp = this.customizeComponent(labelText, aComp);
        ComponentBehavior behavior = this.baseComponentBehavior.apply(modifiers);
        this.addImpl(labelComp, comp, behavior);
        return this;
    }

    @Override
    public PanelBuilder addFlexibleSpace() {
        return this.add((JComponent)new FlexibleSpaceComp(), Modifiers.GROW_LESS, Modifiers.GROW_LESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JComponent get(PanelPostProcessor ... ppps) {
        try {
            JComponent product = this.getImpl();
            for (PanelPostProcessor ppp : ppps) {
                product = ppp.process(product);
            }
            JComponent jComponent = product;
            return jComponent;
        }
        finally {
            this.currentBuildCustomizers = null;
            if (this.myPool != null) {
                this.myPool.add(this);
            }
        }
    }

    protected abstract void beginImpl(JComponent var1);

    protected abstract void addHeaderImpl(JComponent var1);

    protected abstract void addImpl(JComponent var1, JComponent var2, ComponentBehavior var3);

    protected abstract JComponent getImpl();

    protected JComponent customizeComponent(String labelText, JComponent c) {
        if (this.currentBuildCustomizers != null) {
            for (PanelMaticComponentCustomizer cust : this.currentBuildCustomizers) {
                c = cust.customize(labelText, c);
            }
        }
        for (PanelMaticComponentCustomizer cust : this.customizerChain) {
            c = cust.customize(labelText, c);
        }
        return c;
    }

    protected String getResourceString(String key) {
        if (key == null) {
            return null;
        }
        return this.resourceBundle == null ? key : this.resourceBundle.getString(key);
    }

    public ComponentBehavior getBaseComponentBehavior() {
        return this.baseComponentBehavior;
    }

    @Override
    public List<PanelMaticComponentCustomizer> getCustomizerChain() {
        return this.customizerChain;
    }

    public ComponentBehavior getHeaderBehavior() {
        return this.headerBehavior;
    }

    public ComponentBehavior getLabelBehavior() {
        return this.labelBehavior;
    }

    public void setBaseComponentBehavior(ComponentBehavior baseComponentBehavior) {
        this.baseComponentBehavior = baseComponentBehavior;
    }

    @Override
    public void setBuilderPool(BuilderPool aPool) {
        this.myPool = aPool;
    }

    public PanelBuilderComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public void setComponentFactory(PanelBuilderComponentFactory aComponentFactory) {
        this.componentFactory = aComponentFactory;
    }

    public void setHeaderBehavior(ComponentBehavior aHeaderBehavior) {
        this.headerBehavior = aHeaderBehavior;
    }

    public void setLabelBehavior(ComponentBehavior aLabelBehavior) {
        this.labelBehavior = aLabelBehavior;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public AbstractPanelBuilder setResourceBundle(ResourceBundle aResourceBundle) {
        this.resourceBundle = aResourceBundle;
        return this;
    }
}

