/*
 * Decompiled with CFR 0.152.
 */
package io.codeworth.panelmatic.componentbehavior;

import io.codeworth.panelmatic.componentbehavior.BehaviorModifier;
import io.codeworth.panelmatic.componentbehavior.LineAlign;
import io.codeworth.panelmatic.componentbehavior.PageAlign;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentBehavior
implements Cloneable {
    private LineAlign lineAlign = LineAlign.CENTER;
    private PageAlign pageAlign = PageAlign.MIDDLE;
    private boolean pageStretch;
    private boolean lineStretch;
    private double pageGrowFactor;
    private Insets insets = new Insets(0, 0, 0, 0);

    public LineAlign getLineAlign() {
        return this.lineAlign;
    }

    public void setLineAlign(LineAlign lineAlign) {
        this.lineAlign = lineAlign;
    }

    public boolean isLineStretch() {
        return this.lineStretch;
    }

    public void setLineStretch(boolean lineStretch) {
        this.lineStretch = lineStretch;
    }

    public PageAlign getPageAlign() {
        return this.pageAlign;
    }

    public void setPageAlign(PageAlign pageAlign) {
        this.pageAlign = pageAlign;
    }

    public boolean isPageStretch() {
        return this.pageStretch;
    }

    public void setPageStretch(boolean pageStretch) {
        this.pageStretch = pageStretch;
    }

    public double getPageGrowFactor() {
        return this.pageGrowFactor;
    }

    public void setPageGrowFactor(double pageGrowFactor) {
        this.pageGrowFactor = pageGrowFactor;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentBehavior other = (ComponentBehavior)obj;
        if (!(this.lineAlign == other.lineAlign || this.lineAlign != null && this.lineAlign.equals((Object)other.lineAlign))) {
            return false;
        }
        if (!(this.pageAlign == other.pageAlign || this.pageAlign != null && this.pageAlign.equals((Object)other.pageAlign))) {
            return false;
        }
        if (this.pageStretch != other.pageStretch) {
            return false;
        }
        if (this.lineStretch != other.lineStretch) {
            return false;
        }
        if (Math.abs(this.pageGrowFactor - other.pageGrowFactor) > 0.001) {
            return false;
        }
        return this.insets == other.insets || this.insets != null && this.insets.equals(other.insets);
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + (this.lineAlign != null ? this.lineAlign.hashCode() : 0);
        hash = 59 * hash + (this.pageAlign != null ? this.pageAlign.hashCode() : 0);
        hash = 59 * hash + (this.pageStretch ? 1 : 0);
        hash = 59 * hash + (this.lineStretch ? 1 : 0);
        return hash;
    }

    public ComponentBehavior clone() {
        try {
            ComponentBehavior meAgain = (ComponentBehavior)super.clone();
            meAgain.insets = (Insets)this.getInsets().clone();
            meAgain.lineAlign = this.getLineAlign();
            meAgain.lineStretch = this.isLineStretch();
            meAgain.pageAlign = this.getPageAlign();
            meAgain.pageStretch = this.isPageStretch();
            meAgain.pageGrowFactor = this.getPageGrowFactor();
            return meAgain;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(ComponentBehavior.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String toString() {
        return "ComponentBehavior{lineAlign=" + this.lineAlign + "pageAlign=" + this.pageAlign + "pageStretch=" + this.pageStretch + "lineStretch=" + this.lineStretch + "pageGrowFactor=" + this.pageGrowFactor + "insets=" + this.insets + "}";
    }

    public ComponentBehavior apply(BehaviorModifier ... modifiers) {
        ComponentBehavior minime = this.clone();
        for (BehaviorModifier m : modifiers) {
            minime = m.modify(minime);
        }
        return minime;
    }
}

