/*
 * Decompiled with CFR 0.152.
 */
package io.codeworth.panelmatic;

import io.codeworth.panelmatic.BuilderPool;
import io.codeworth.panelmatic.PanelBuilder;
import io.codeworth.panelmatic.PanelBuilderFactory;
import io.codeworth.panelmatic.PanelMaticComponentCustomizer;
import io.codeworth.panelmatic.impl.gridbagpanelbuilder.GbPanelBuilderFactory;
import java.awt.ComponentOrientation;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class PanelMatic {
    private static final String PANEL_BUILDER_FACTORY_CLASS_PROPERTY = "org.panelmatic.PanelBuilderFactory";
    private static BuilderPool builderPool = new BuilderPool();
    private static PanelBuilderFactory builderFactory;
    private static ComponentOrientation orientation;
    private static ResourceBundle l10nBundle;

    static void autosetBuilderFactory() {
        boolean builderFactorySet = false;
        String factoryClassName = System.getProperty(PANEL_BUILDER_FACTORY_CLASS_PROPERTY);
        if (factoryClassName != null && !factoryClassName.trim().isEmpty()) {
            try {
                Class<?> factoryClass = Class.forName(factoryClassName);
                PanelMatic.setBuilderFactory((PanelBuilderFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                builderFactorySet = true;
            }
            catch (InstantiationException ex) {
                Logger.getLogger(PanelMatic.class.getName()).log(Level.SEVERE, "Instantiation error for panel builder factory " + factoryClassName, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(PanelMatic.class.getName()).log(Level.SEVERE, "IllegalAccessException error for panel builder factory " + factoryClassName, ex);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(PanelMatic.class.getName()).log(Level.SEVERE, "Panel builder factory class '" + factoryClassName + "' not found. ", ex);
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(PanelMatic.class.getName()).log(Level.SEVERE, "Panel builder factory class '" + factoryClassName + "' has no no-args constructor. ", ex);
            }
            catch (IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(PanelMatic.class.getName()).log(Level.SEVERE, "Panel builder factory class '" + factoryClassName + "' no-args constructor cannot be invoked: " + ex.getMessage(), ex);
            }
        }
        if (!builderFactorySet) {
            PanelMatic.setBuilderFactory(new GbPanelBuilderFactory());
        }
    }

    public static void setBuilderFactory(PanelBuilderFactory pbf) {
        if (pbf == null) {
            throw new IllegalArgumentException("PanelBuilderFactory cannot be null");
        }
        if (pbf.equals(builderFactory)) {
            return;
        }
        builderFactory = pbf;
        builderPool = new BuilderPool();
    }

    public static PanelBuilder begin(PanelMaticComponentCustomizer ... custsForCurrentBuild) {
        return PanelMatic.getBuilder().begin(custsForCurrentBuild);
    }

    public static PanelBuilder begin(JComponent basePanel, PanelMaticComponentCustomizer ... custsForCurrentBuild) {
        return PanelMatic.getBuilder().begin(basePanel, custsForCurrentBuild);
    }

    public static void setLocalizationBundle(ResourceBundle aBundle) {
        l10nBundle = aBundle;
        builderFactory.setLocalizationBundle(l10nBundle);
        builderPool.clear();
    }

    public static ResourceBundle getLocalizationBundle() {
        return l10nBundle;
    }

    public static void setComponentOrientation(ComponentOrientation anOrientation) {
        orientation = anOrientation;
        builderFactory.setComponentOrientation(anOrientation);
        builderPool.clear();
    }

    public static ComponentOrientation getComponentOrientation() {
        return orientation;
    }

    private static PanelBuilder getBuilder() {
        PanelBuilder b = builderPool.get();
        if (b == null) {
            if (builderFactory == null) {
                PanelMatic.autosetBuilderFactory();
            }
            b = builderFactory.build();
            b.setBuilderPool(builderPool);
        }
        return b;
    }

    static {
        orientation = ComponentOrientation.UNKNOWN;
        l10nBundle = null;
    }
}

