/*
 * Decompiled with CFR 0.152.
 */
package io.codepace;

import io.codepace.HttpTypes;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javafx.util.Pair;

public class SimpleHttpRequest {
    private String hostname;
    private HttpTypes type = HttpTypes.GET;
    private String putFilePath = "";
    private String prevResponse = "";
    private StringBuilder completeParams = new StringBuilder();
    public String postBody = "";

    public SimpleHttpRequest(String hostname, HttpTypes type) {
        this.hostname = hostname;
        this.type = type;
    }

    public SimpleHttpRequest(String hostname) {
        this.hostname = hostname;
    }

    public SimpleHttpRequest(String hostname, String putFilePath) {
        this.hostname = hostname;
        this.putFilePath = putFilePath;
    }

    public SimpleHttpRequest(String hostname, Pair<String, String>[] postParams) {
        this.hostname = hostname;
        for (int i = 0; i < postParams.length; ++i) {
            if (i != 0) {
                this.completeParams.append("&");
            }
            this.completeParams.append((String)postParams[i].getKey()).append("=").append((String)postParams[i].getValue());
        }
        if (this.completeParams.charAt(this.completeParams.length() - 1) == '&') {
            this.completeParams.deleteCharAt(this.completeParams.length() - 1);
        }
    }

    public String fire() throws IOException {
        String res = "";
        switch (this.type) {
            case GET: {
                res = this.fireGet();
            }
            case PUT: {
                res = this.firePut();
            }
            case HEAD: {
                res = this.fireHead();
            }
            case POST: {
                res = this.firePost();
            }
            case POST_PARAMS: {
                res = this.fireJsonPost(this.postBody);
            }
            case TRACE: {
                res = this.fireTrace();
            }
            case CONNECT: {
                res = this.fireConnect();
            }
            case OPTIONS: {
                res = this.fireOptions();
            }
        }
        this.prevResponse = "";
        this.prevResponse = res;
        return res;
    }

    private String fireOptions() throws IOException {
        URL url = new URL(this.hostname);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(this.type.toString());
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String inLine = null;
        StringBuffer res = new StringBuffer();
        while ((inLine = in.readLine()) != null) {
            res.append(inLine);
        }
        in.close();
        return res.toString();
    }

    private String firePut() throws IOException {
        String line;
        URL url = new URL(this.hostname);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        String baseUrl = url.getProtocol() + "://" + url.getHost();
        FileReader fr = new FileReader(this.putFilePath);
        BufferedReader reader = new BufferedReader(fr);
        StringBuilder contents = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            contents.append(line);
        }
        String data = contents.toString();
        conn.setRequestMethod(this.type.toString());
        conn.setRequestProperty("Host", baseUrl);
        conn.setRequestProperty("Content-type", "text/html");
        conn.setRequestProperty("Content-length", String.valueOf(data.getBytes().length));
        conn.getOutputStream().write(data.getBytes("UTF-8"));
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String inLine = null;
        StringBuffer res = new StringBuffer();
        while ((inLine = in.readLine()) != null) {
            res.append(inLine);
        }
        in.close();
        return res.toString();
    }

    private String fireHead() throws IOException {
        URL url = new URL(this.hostname);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(this.type.toString());
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String inLine = null;
        StringBuffer res = new StringBuffer();
        while ((inLine = in.readLine()) != null) {
            res.append(inLine);
        }
        in.close();
        return res.toString();
    }

    private String firePost() throws IOException {
        URL url = new URL(this.hostname);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(this.type.toString());
        conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        conn.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        String urlParams = this.completeParams.toString();
        conn.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.writeBytes(urlParams);
        wr.flush();
        wr.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String inLine = null;
        StringBuffer res = new StringBuffer();
        while ((inLine = in.readLine()) != null) {
            res.append(inLine);
        }
        in.close();
        return res.toString();
    }

    private String fireJsonPost(String content) throws IOException {
        URL url = new URL(this.hostname);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(this.type.toString());
        conn.setRequestProperty("Content-Type", "application/json");
        conn.getOutputStream().write(content.getBytes("UTF-8"));
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String inLine = null;
        StringBuffer res = new StringBuffer();
        while ((inLine = in.readLine()) != null) {
            res.append(inLine);
        }
        in.close();
        return res.toString();
    }

    private String fireTrace() throws IOException {
        URL url = new URL(this.hostname);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(this.type.toString());
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String inLine = null;
        StringBuffer res = new StringBuffer();
        while ((inLine = in.readLine()) != null) {
            res.append(inLine);
        }
        in.close();
        return res.toString();
    }

    private String fireConnect() throws IOException {
        URL url = new URL(this.hostname);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(this.type.toString());
        conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String inLine = null;
        StringBuffer res = new StringBuffer();
        while ((inLine = in.readLine()) != null) {
            res.append(inLine);
        }
        in.close();
        return res.toString();
    }

    private String fireGet() throws IOException {
        URL url = new URL(this.hostname);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(this.type.toString());
        conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String inLine = null;
        StringBuffer res = new StringBuffer();
        while ((inLine = in.readLine()) != null) {
            res.append(inLine);
        }
        in.close();
        return res.toString();
    }

    public String getResponse() {
        return this.prevResponse;
    }
}

