/*
 * Decompiled with CFR 0.152.
 */
package io.codepace;

import io.codepace.HttpTypes;
import io.codepace.SimpleHttpRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetUtils {
    public boolean pingHost(String host) {
        boolean reach;
        try {
            InetAddress addr = InetAddress.getByName(host);
            reach = addr.isReachable(3000);
        }
        catch (IOException ioe) {
            System.err.println("Unable to reach " + host + " (" + ioe.getMessage() + ")");
            return false;
        }
        return reach;
    }

    public boolean pingAddr(String addr) {
        boolean reach;
        try {
            InetAddress host = InetAddress.getByName(addr);
            reach = host.isReachable(3000);
        }
        catch (IOException ioe) {
            System.err.println("Unable to reach " + addr + " (" + ioe.getMessage() + ")");
            return false;
        }
        return reach;
    }

    public String HttpRequest(String host, HttpTypes type) {
        SimpleHttpRequest simpleHttpRequest = new SimpleHttpRequest(host, type);
        try {
            return simpleHttpRequest.fire();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "";
        }
    }

    public String getWanIp() {
        try {
            URL whatismyip = new URL("http://checkip.amazonaws.com");
            BufferedReader in = new BufferedReader(new InputStreamReader(whatismyip.openStream()));
            return in.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "";
        }
    }

    public String getLocalIp() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "";
        }
    }

    public String urlShortenGoogle(String url) {
        String jUulkiggf = "QUl6YVN5RFozNnRGNmlWekxSTncySDJKSzZ0S1RuMlJic1RHUjln";
        SimpleHttpRequest req = new SimpleHttpRequest("https://www.googleapis.com/urlshortener/v1/url?key=" + Base64.getDecoder().decode(jUulkiggf), HttpTypes.POST);
        req.postBody = "{\"longUrl\": \"" + url + "\"/";
        Pattern pattern = Pattern.compile("\"id\": \"(.+?)\"");
        try {
            String res = req.fire();
            Matcher matcher = pattern.matcher(res);
            matcher.find();
            return matcher.group(1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "";
        }
    }
}

