/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.rabbitmq;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.base.Optional;
import com.rabbitmq.client.Connection;
import io.codemonastery.dropwizard.rabbitmq.ConnectAsync;
import io.codemonastery.dropwizard.rabbitmq.ConnectedCallback;
import io.codemonastery.dropwizard.rabbitmq.ConnectionConfiguration;
import io.codemonastery.dropwizard.rabbitmq.ConnectionHealthCheck;
import io.codemonastery.dropwizard.rabbitmq.ConnectionMetrics;
import io.codemonastery.dropwizard.rabbitmq.DefaultConnectionMetrics;
import io.codemonastery.dropwizard.rabbitmq.ManageConnection;
import io.codemonastery.dropwizard.rabbitmq.WrappedConnectionMetrics;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ConnectionFactory
extends ConnectionConfiguration {
    private ConnectionMetrics metrics;

    public ConnectionFactory customMetrics(ConnectionMetrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public Connection build(Environment env, ExecutorService deliveryExecutor, String name) throws IOException, TimeoutException {
        HealthCheckRegistry healthChecks = env.healthChecks();
        LifecycleEnvironment lifecycle = env.lifecycle();
        MetricRegistry metrics = env.metrics();
        return this.build(healthChecks, lifecycle, metrics, deliveryExecutor, name);
    }

    public Connection build(@Nullable HealthCheckRegistry healthChecks, @Nullable LifecycleEnvironment lifecycle, @Nullable MetricRegistry metrics, ExecutorService deliveryExecutor, String name) throws IOException, TimeoutException {
        com.rabbitmq.client.ConnectionFactory connectionFactory = this.makeConnectionFactory();
        ConnectionMetrics connectionMetrics = (ConnectionMetrics)Optional.fromNullable((Object)this.metrics).or(() -> new DefaultConnectionMetrics(name, metrics));
        Connection connection = connectionFactory.newConnection(deliveryExecutor);
        this.registerWithEnvironment(healthChecks, lifecycle, () -> connection, name);
        return new WrappedConnectionMetrics(connectionMetrics).wrap(connection);
    }

    public void buildRetryInitialConnect(Environment env, ExecutorService deliveryExecutor, String name, ConnectedCallback callback) {
        com.rabbitmq.client.ConnectionFactory connectionFactory = this.makeConnectionFactory();
        ScheduledExecutorService initialConnectExecutor = env.lifecycle().scheduledExecutorService(name + "-initial-connect-thread").threads(1).build();
        ConnectionMetrics connectionMetrics = (ConnectionMetrics)Optional.fromNullable((Object)this.metrics).or(() -> new DefaultConnectionMetrics(name, env.metrics()));
        WrappedConnectionMetrics connectionMetricsWrapper = new WrappedConnectionMetrics(connectionMetrics);
        ConnectedCallback callbackWithMetrics = connection -> {
            Connection metricsConnection = connectionMetricsWrapper.wrap(connection);
            callback.connected(metricsConnection);
        };
        ConnectAsync connectAsync = new ConnectAsync(connectionFactory, deliveryExecutor, name, initialConnectExecutor, callbackWithMetrics);
        this.registerWithEnvironment(env.healthChecks(), env.lifecycle(), connectAsync::getConnection, name);
        connectAsync.run();
    }

    private void registerWithEnvironment(HealthCheckRegistry healthChecks, LifecycleEnvironment lifecycle, Supplier<Connection> connection, String name) {
        if (healthChecks != null) {
            healthChecks.register(name, (HealthCheck)new ConnectionHealthCheck(connection));
        }
        if (lifecycle != null) {
            lifecycle.manage((Managed)new ManageConnection(connection));
        }
    }
}

