/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.rabbitmq;

import com.codahale.metrics.health.HealthCheck;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.function.Supplier;

class ConnectionHealthCheck
extends HealthCheck {
    private final Supplier<Connection> connection;

    public ConnectionHealthCheck(Supplier<Connection> connection) {
        this.connection = connection;
    }

    protected HealthCheck.Result check() throws Exception {
        HealthCheck.Result result;
        Connection connection = this.connection.get();
        if (connection != null && connection.isOpen()) {
            try {
                Channel channel = connection.createChannel();
                channel.close();
                result = HealthCheck.Result.healthy();
            }
            catch (IOException e) {
                result = HealthCheck.Result.unhealthy((String)"Connection is open, could not create channel");
            }
        } else {
            result = HealthCheck.Result.unhealthy((String)"Not Connected");
        }
        return result;
    }
}

