/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.FlowListener;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import io.codemonastery.dropwizard.rabbitmq.WrappedConnectionMetrics;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeoutException;

class ChannelWithMetrics
implements Channel {
    private final Channel delegate;
    private final WrappedConnectionMetrics connectionMetrics;

    public ChannelWithMetrics(Channel delegate, WrappedConnectionMetrics connectionMetrics) {
        this.delegate = delegate;
        this.connectionMetrics = connectionMetrics;
    }

    public int getChannelNumber() {
        return this.delegate.getChannelNumber();
    }

    public Connection getConnection() {
        return this.delegate.getConnection();
    }

    public void close() throws IOException, TimeoutException {
        this.delegate.close();
    }

    public void close(int closeCode, String closeMessage) throws IOException, TimeoutException {
        this.delegate.close(closeCode, closeMessage);
    }

    public boolean flowBlocked() {
        return this.delegate.flowBlocked();
    }

    public void abort() throws IOException {
        this.delegate.abort();
    }

    public void abort(int closeCode, String closeMessage) throws IOException {
        this.delegate.abort(closeCode, closeMessage);
    }

    public void addReturnListener(ReturnListener listener) {
        this.delegate.addReturnListener(listener);
    }

    public boolean removeReturnListener(ReturnListener listener) {
        return this.delegate.removeReturnListener(listener);
    }

    public void clearReturnListeners() {
        this.delegate.clearReturnListeners();
    }

    public void addFlowListener(FlowListener listener) {
        this.delegate.addFlowListener(listener);
    }

    public boolean removeFlowListener(FlowListener listener) {
        return this.delegate.removeFlowListener(listener);
    }

    @Deprecated
    public void clearFlowListeners() {
        this.delegate.clearFlowListeners();
    }

    public void addConfirmListener(ConfirmListener listener) {
        this.delegate.addConfirmListener(listener);
    }

    public boolean removeConfirmListener(ConfirmListener listener) {
        return this.delegate.removeConfirmListener(listener);
    }

    public void clearConfirmListeners() {
        this.delegate.clearConfirmListeners();
    }

    public Consumer getDefaultConsumer() {
        return this.delegate.getDefaultConsumer();
    }

    public void setDefaultConsumer(Consumer consumer) {
        this.delegate.setDefaultConsumer(consumer);
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global) throws IOException {
        this.delegate.basicQos(prefetchSize, prefetchCount, global);
    }

    public void basicQos(int prefetchCount, boolean global) throws IOException {
        this.delegate.basicQos(prefetchCount, global);
    }

    public void basicQos(int prefetchCount) throws IOException {
        this.delegate.basicQos(prefetchCount);
    }

    public void basicPublish(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.delegate.basicPublish(exchange, routingKey, props, body);
        this.connectionMetrics.published();
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.delegate.basicPublish(exchange, routingKey, mandatory, props, body);
        this.connectionMetrics.published();
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.delegate.basicPublish(exchange, routingKey, mandatory, immediate, props, body);
        this.connectionMetrics.published();
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type, durable);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments);
    }

    public void exchangeDeclareNoWait(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        this.delegate.exchangeDeclareNoWait(exchange, type, durable, autoDelete, internal, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclarePassive(String name) throws IOException {
        return this.delegate.exchangeDeclarePassive(name);
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange, boolean ifUnused) throws IOException {
        return this.delegate.exchangeDelete(exchange, ifUnused);
    }

    public void exchangeDeleteNoWait(String exchange, boolean ifUnused) throws IOException {
        this.delegate.exchangeDeleteNoWait(exchange, ifUnused);
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange) throws IOException {
        return this.delegate.exchangeDelete(exchange);
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey) throws IOException {
        return this.delegate.exchangeBind(destination, source, routingKey);
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeBind(destination, source, routingKey, arguments);
    }

    public void exchangeBindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        this.delegate.exchangeBindNoWait(destination, source, routingKey, arguments);
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey) throws IOException {
        return this.delegate.exchangeUnbind(destination, source, routingKey);
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.delegate.exchangeUnbind(destination, source, routingKey, arguments);
    }

    public void exchangeUnbindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        this.delegate.exchangeUnbindNoWait(destination, source, routingKey, arguments);
    }

    public AMQP.Queue.DeclareOk queueDeclare() throws IOException {
        return this.delegate.queueDeclare();
    }

    public AMQP.Queue.DeclareOk queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, arguments);
    }

    public void queueDeclareNoWait(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        this.delegate.queueDeclareNoWait(queue, durable, exclusive, autoDelete, arguments);
    }

    public AMQP.Queue.DeclareOk queueDeclarePassive(String queue) throws IOException {
        return this.delegate.queueDeclarePassive(queue);
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue) throws IOException {
        return this.delegate.queueDelete(queue);
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
        return this.delegate.queueDelete(queue, ifUnused, ifEmpty);
    }

    public void queueDeleteNoWait(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
        this.delegate.queueDeleteNoWait(queue, ifUnused, ifEmpty);
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey) throws IOException {
        return this.delegate.queueBind(queue, exchange, routingKey);
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.delegate.queueBind(queue, exchange, routingKey, arguments);
    }

    public void queueBindNoWait(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        this.delegate.queueBindNoWait(queue, exchange, routingKey, arguments);
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey) throws IOException {
        return this.delegate.queueUnbind(queue, exchange, routingKey);
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.delegate.queueUnbind(queue, exchange, routingKey, arguments);
    }

    public AMQP.Queue.PurgeOk queuePurge(String queue) throws IOException {
        return this.delegate.queuePurge(queue);
    }

    public GetResponse basicGet(String queue, boolean autoAck) throws IOException {
        this.connectionMetrics.delivered();
        return this.delegate.basicGet(queue, autoAck);
    }

    public void basicAck(long deliveryTag, boolean multiple) throws IOException {
        this.delegate.basicAck(deliveryTag, multiple);
        this.connectionMetrics.acked();
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) throws IOException {
        this.delegate.basicNack(deliveryTag, multiple, requeue);
        this.connectionMetrics.nacked();
    }

    public void basicReject(long deliveryTag, boolean requeue) throws IOException {
        this.delegate.basicReject(deliveryTag, requeue);
        this.connectionMetrics.rejected();
    }

    public String basicConsume(String queue, Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, this.connectionMetrics.wrap(callback));
    }

    public String basicConsume(String queue, boolean autoAck, Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, this.connectionMetrics.wrap(callback));
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, arguments, this.connectionMetrics.wrap(callback));
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, consumerTag, this.connectionMetrics.wrap(callback));
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, Consumer callback) throws IOException {
        return this.delegate.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, this.connectionMetrics.wrap(callback));
    }

    public void basicCancel(String consumerTag) throws IOException {
        this.delegate.basicCancel(consumerTag);
    }

    public AMQP.Basic.RecoverOk basicRecover() throws IOException {
        return this.delegate.basicRecover();
    }

    public AMQP.Basic.RecoverOk basicRecover(boolean requeue) throws IOException {
        return this.delegate.basicRecover(requeue);
    }

    public AMQP.Tx.SelectOk txSelect() throws IOException {
        return this.delegate.txSelect();
    }

    public AMQP.Tx.CommitOk txCommit() throws IOException {
        return this.delegate.txCommit();
    }

    public AMQP.Tx.RollbackOk txRollback() throws IOException {
        return this.delegate.txRollback();
    }

    public AMQP.Confirm.SelectOk confirmSelect() throws IOException {
        return this.delegate.confirmSelect();
    }

    public long getNextPublishSeqNo() {
        return this.delegate.getNextPublishSeqNo();
    }

    public boolean waitForConfirms() throws InterruptedException {
        return this.delegate.waitForConfirms();
    }

    public boolean waitForConfirms(long timeout) throws InterruptedException, TimeoutException {
        return this.delegate.waitForConfirms(timeout);
    }

    public void waitForConfirmsOrDie() throws IOException, InterruptedException {
        this.delegate.waitForConfirmsOrDie();
    }

    public void waitForConfirmsOrDie(long timeout) throws IOException, InterruptedException, TimeoutException {
        this.delegate.waitForConfirmsOrDie(timeout);
    }

    public void asyncRpc(Method method) throws IOException {
        this.delegate.asyncRpc(method);
    }

    public Command rpc(Method method) throws IOException {
        return this.delegate.rpc(method);
    }

    public long messageCount(String s) throws IOException {
        return this.delegate.messageCount(s);
    }

    public long consumerCount(String s) throws IOException {
        return this.delegate.consumerCount(s);
    }

    public void addShutdownListener(ShutdownListener listener) {
        this.delegate.addShutdownListener(listener);
    }

    public void removeShutdownListener(ShutdownListener listener) {
        this.delegate.removeShutdownListener(listener);
    }

    public ShutdownSignalException getCloseReason() {
        return this.delegate.getCloseReason();
    }

    public void notifyListeners() {
        this.delegate.notifyListeners();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }
}

