/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.rabbitmq;

import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import io.codemonastery.dropwizard.rabbitmq.WrappedConnectionMetrics;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;

class ConnectionWithMetrics
implements Connection {
    private final Connection delegate;
    private final WrappedConnectionMetrics connectionMetrics;

    ConnectionWithMetrics(Connection delegate, WrappedConnectionMetrics connectionMetrics) {
        this.delegate = delegate;
        this.connectionMetrics = connectionMetrics;
    }

    public InetAddress getAddress() {
        return this.delegate.getAddress();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public int getChannelMax() {
        return this.delegate.getChannelMax();
    }

    public int getFrameMax() {
        return this.delegate.getFrameMax();
    }

    public int getHeartbeat() {
        return this.delegate.getHeartbeat();
    }

    public Map<String, Object> getClientProperties() {
        return this.delegate.getClientProperties();
    }

    public String getClientProvidedName() {
        return this.delegate.getClientProvidedName();
    }

    public Map<String, Object> getServerProperties() {
        return this.delegate.getServerProperties();
    }

    public Channel createChannel() throws IOException {
        return this.connectionMetrics.wrap(this.delegate.createChannel());
    }

    public Channel createChannel(int channelNumber) throws IOException {
        return this.connectionMetrics.wrap(this.delegate.createChannel(channelNumber));
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public void close(int closeCode, String closeMessage) throws IOException {
        this.delegate.close(closeCode, closeMessage);
    }

    public void close(int timeout) throws IOException {
        this.delegate.close(timeout);
    }

    public void close(int closeCode, String closeMessage, int timeout) throws IOException {
        this.delegate.close(closeCode, closeMessage, timeout);
    }

    public void abort() {
        this.delegate.abort();
    }

    public void abort(int closeCode, String closeMessage) {
        this.delegate.abort(closeCode, closeMessage);
    }

    public void abort(int timeout) {
        this.delegate.abort(timeout);
    }

    public void abort(int closeCode, String closeMessage, int timeout) {
        this.delegate.abort(closeCode, closeMessage, timeout);
    }

    public void addBlockedListener(BlockedListener listener) {
        this.delegate.addBlockedListener(listener);
    }

    public boolean removeBlockedListener(BlockedListener listener) {
        return this.delegate.removeBlockedListener(listener);
    }

    public void clearBlockedListeners() {
        this.delegate.clearBlockedListeners();
    }

    public ExceptionHandler getExceptionHandler() {
        return this.delegate.getExceptionHandler();
    }

    public void addShutdownListener(ShutdownListener listener) {
        this.delegate.addShutdownListener(listener);
    }

    public void removeShutdownListener(ShutdownListener listener) {
        this.delegate.removeShutdownListener(listener);
    }

    public ShutdownSignalException getCloseReason() {
        return this.delegate.getCloseReason();
    }

    public void notifyListeners() {
        this.delegate.notifyListeners();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }
}

