/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.rabbitmq;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import io.codemonastery.dropwizard.rabbitmq.ConnectionMetrics;

public class DefaultConnectionMetrics
implements ConnectionMetrics {
    private final Meter deliveryMeter;
    private final Meter ackMeter;
    private final Meter nackMeter;
    private final Meter publishMeter;
    private final Meter rejectMeter;

    public DefaultConnectionMetrics(String connectionName, MetricRegistry metrics) {
        this.deliveryMeter = metrics.meter(connectionName + "-delivery");
        this.ackMeter = metrics.meter(connectionName + "-ack");
        this.nackMeter = metrics.meter(connectionName + "-nack");
        this.rejectMeter = metrics.meter(connectionName + "-reject");
        this.publishMeter = metrics.meter(connectionName + "-publish");
    }

    @Override
    public void delivered() {
        this.deliveryMeter.mark();
    }

    @Override
    public void acked() {
        this.ackMeter.mark();
    }

    @Override
    public void nacked() {
        this.nackMeter.mark();
    }

    @Override
    public void rejected() {
        this.rejectMeter.mark();
    }

    @Override
    public void published() {
        this.publishMeter.mark();
    }
}

