/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import io.codemonastery.dropwizard.rabbitmq.WrappedConnectionMetrics;
import java.io.IOException;

public class ConsumerWithMetrics
implements Consumer {
    private final Consumer delegate;
    private final WrappedConnectionMetrics connectionMetrics;

    public ConsumerWithMetrics(Consumer delegate, WrappedConnectionMetrics connectionMetrics) {
        this.delegate = delegate;
        this.connectionMetrics = connectionMetrics;
    }

    public void handleConsumeOk(String consumerTag) {
        this.delegate.handleConsumeOk(consumerTag);
    }

    public void handleCancelOk(String consumerTag) {
        this.delegate.handleCancelOk(consumerTag);
    }

    public void handleCancel(String consumerTag) throws IOException {
        this.delegate.handleCancel(consumerTag);
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        this.delegate.handleShutdownSignal(consumerTag, sig);
    }

    public void handleRecoverOk(String consumerTag) {
        this.delegate.handleRecoverOk(consumerTag);
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        this.connectionMetrics.delivered();
        this.delegate.handleDelivery(consumerTag, envelope, properties, body);
    }
}

