/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.rabbitmq;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.rabbitmq.client.ConnectionFactory;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MaxDuration;
import io.dropwizard.validation.MinDuration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;

public class ConnectionConfiguration {
    private String username;
    private String password;
    private String virtualHost;
    private String host;
    @Min(value=1L)
    private Integer port;
    @Min(value=0L)
    private Integer requestedChannelMax;
    @Min(value=0L)
    private Integer requestedFrameMax;
    @MinDuration(value=0L, unit=TimeUnit.SECONDS)
    @MaxDuration(value=0x7FFFFFFFL, unit=TimeUnit.SECONDS)
    private Duration requestedHeartbeat;
    @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS)
    @MaxDuration(value=0x7FFFFFFFL, unit=TimeUnit.MILLISECONDS)
    private Duration connectionTimeout;
    @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS)
    @MaxDuration(value=0x7FFFFFFFL, unit=TimeUnit.MILLISECONDS)
    private Duration handshakeTimeout;
    @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS)
    @MaxDuration(value=0x7FFFFFFFL, unit=TimeUnit.MILLISECONDS)
    private Duration shutdownTimeout;
    private Map<String, Object> clientProperties;
    @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS)
    @MaxDuration(value=0x7FFFFFFFFFFFFFFFL, unit=TimeUnit.MILLISECONDS)
    private Duration networkRecoveryInterval;

    @JsonProperty
    public String getUsername() {
        return this.username;
    }

    @JsonProperty
    public void setUsername(String username) {
        this.username = username;
    }

    @JsonProperty
    public String getPassword() {
        return this.password;
    }

    @JsonProperty
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonProperty
    public String getVirtualHost() {
        return this.virtualHost;
    }

    @JsonProperty
    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(Integer port) {
        this.port = port;
    }

    @JsonProperty
    public Integer getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    @JsonProperty
    public void setRequestedChannelMax(Integer requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
    }

    @JsonProperty
    public Integer getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    @JsonProperty
    public void setRequestedFrameMax(Integer requestedFrameMax) {
        this.requestedFrameMax = requestedFrameMax;
    }

    @JsonProperty
    public Duration getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    @JsonProperty
    public void setRequestedHeartbeat(Duration requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
    }

    @JsonProperty
    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @JsonProperty
    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @JsonProperty
    public Duration getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    @JsonProperty
    public void setHandshakeTimeout(Duration handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
    }

    @JsonProperty
    public Duration getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @JsonProperty
    public void setShutdownTimeout(Duration shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    @JsonProperty
    public Map<String, Object> getClientProperties() {
        return this.clientProperties;
    }

    @JsonProperty
    public void setClientProperties(Map<String, Object> clientProperties) {
        this.clientProperties = clientProperties;
    }

    @JsonProperty
    public Duration getNetworkRecoveryInterval() {
        return this.networkRecoveryInterval;
    }

    @JsonProperty
    public void setNetworkRecoveryInterval(Duration networkRecoveryInterval) {
        this.networkRecoveryInterval = networkRecoveryInterval;
    }

    protected ConnectionFactory makeConnectionFactory() {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        String username = (String)Optional.fromNullable((Object)this.getUsername()).or((Object)"guest");
        String password = (String)Optional.fromNullable((Object)this.getPassword()).or((Object)"guest");
        String vhost = (String)Optional.fromNullable((Object)this.getVirtualHost()).or((Object)"/");
        String host = (String)Optional.fromNullable((Object)this.getHost()).or((Object)"localhost");
        int amqpPort = (Integer)Optional.fromNullable((Object)this.getPort()).or((Object)5672);
        int channelMax = (Integer)Optional.fromNullable((Object)this.getRequestedChannelMax()).or((Object)0);
        int frameMax = (Integer)Optional.fromNullable((Object)this.getRequestedFrameMax()).or((Object)0);
        Duration defaultHeartbeat = (Duration)Optional.fromNullable((Object)this.getRequestedHeartbeat()).or((Object)Duration.seconds((long)60L));
        Duration connectionTimeout = (Duration)Optional.fromNullable((Object)this.getConnectionTimeout()).or((Object)Duration.milliseconds((long)60000L));
        Duration handshakeTimeout = (Duration)Optional.fromNullable((Object)this.getHandshakeTimeout()).or((Object)Duration.milliseconds((long)10000L));
        Duration shutdownTimeout = (Duration)Optional.fromNullable((Object)this.getShutdownTimeout()).or((Object)Duration.milliseconds((long)10000L));
        connectionFactory.setUsername(username);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost(vhost);
        connectionFactory.setHost(host);
        connectionFactory.setPort(amqpPort);
        connectionFactory.setRequestedChannelMax(channelMax);
        connectionFactory.setRequestedFrameMax(frameMax);
        connectionFactory.setRequestedHeartbeat((int)defaultHeartbeat.toSeconds());
        connectionFactory.setConnectionTimeout((int)connectionTimeout.toMilliseconds());
        connectionFactory.setHandshakeTimeout((int)handshakeTimeout.toMilliseconds());
        connectionFactory.setShutdownTimeout((int)shutdownTimeout.toMilliseconds());
        if (this.clientProperties != null) {
            connectionFactory.getClientProperties().putAll(this.clientProperties);
        }
        connectionFactory.setAutomaticRecoveryEnabled(true);
        connectionFactory.setTopologyRecoveryEnabled(true);
        if (this.networkRecoveryInterval != null) {
            connectionFactory.setNetworkRecoveryInterval(this.networkRecoveryInterval.toMilliseconds());
        }
        return connectionFactory;
    }
}

