/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.rabbitmq;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import io.codemonastery.dropwizard.rabbitmq.ConnectedCallback;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectAsync
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectAsync.class);
    private final ConnectionFactory connectionFactory;
    private final ExecutorService consumerExecutorService;
    private final String name;
    private final ScheduledExecutorService initialConnectExecutor;
    private final ConnectedCallback callback;
    private Connection connection;

    public ConnectAsync(ConnectionFactory connectionFactory, ExecutorService consumerExecutorService, String name, ScheduledExecutorService initialConnectExecutor, ConnectedCallback callback) {
        this.connectionFactory = connectionFactory;
        this.consumerExecutorService = consumerExecutorService;
        this.name = name;
        this.initialConnectExecutor = initialConnectExecutor;
        this.callback = callback;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void run() {
        try {
            this.connection = this.connectionFactory.newConnection(this.consumerExecutorService);
            LOG.info("Initial RabbitMQ {}", (Object)this.name);
            this.callback.connected(this.connection);
            this.initialConnectExecutor.shutdown();
        }
        catch (Exception e) {
            String message = String.format("Could not perform initial connection to RabbitMQ %s, will retry until initially connected", this.name);
            LOG.error(message, (Throwable)e);
            this.initialConnectExecutor.schedule(this, this.connectionFactory.getNetworkRecoveryInterval(), TimeUnit.MILLISECONDS);
        }
    }
}

