/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Recoverable;
import io.codemonastery.dropwizard.rabbitmq.AutoRecoveringConnectionWithMetrics;
import io.codemonastery.dropwizard.rabbitmq.AutorecoveringChannelWithMetrics;
import io.codemonastery.dropwizard.rabbitmq.ChannelWithMetrics;
import io.codemonastery.dropwizard.rabbitmq.ConnectionMetrics;
import io.codemonastery.dropwizard.rabbitmq.ConnectionWithMetrics;
import io.codemonastery.dropwizard.rabbitmq.ConsumerWithMetrics;

class WrappedConnectionMetrics
implements ConnectionMetrics {
    private final ConnectionMetrics delegate;

    public WrappedConnectionMetrics(ConnectionMetrics delegate) {
        this.delegate = delegate;
    }

    public Connection wrap(Connection connection) {
        return connection instanceof Recoverable ? new AutoRecoveringConnectionWithMetrics(connection, this) : new ConnectionWithMetrics(connection, this);
    }

    public Channel wrap(Channel channel) {
        return channel instanceof Recoverable ? new AutorecoveringChannelWithMetrics(channel, this) : new ChannelWithMetrics(channel, this);
    }

    public Consumer wrap(Consumer callback) {
        return new ConsumerWithMetrics(callback, this);
    }

    @Override
    public void delivered() {
        this.delegate.delivered();
    }

    @Override
    public void acked() {
        this.delegate.acked();
    }

    @Override
    public void nacked() {
        this.delegate.nacked();
    }

    @Override
    public void rejected() {
        this.delegate.rejected();
    }

    @Override
    public void published() {
        this.delegate.published();
    }
}

