/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.rabbitmq;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Optional;
import com.rabbitmq.client.Connection;
import io.codemonastery.dropwizard.rabbitmq.ConnectAsync;
import io.codemonastery.dropwizard.rabbitmq.ConnectedCallback;
import io.codemonastery.dropwizard.rabbitmq.ConnectionConfiguration;
import io.codemonastery.dropwizard.rabbitmq.ConnectionHealthCheck;
import io.codemonastery.dropwizard.rabbitmq.ConnectionMetrics;
import io.codemonastery.dropwizard.rabbitmq.DefaultConnectionMetrics;
import io.codemonastery.dropwizard.rabbitmq.ManageConnection;
import io.codemonastery.dropwizard.rabbitmq.WrappedConnectionMetrics;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

public class ConnectionFactory
extends ConnectionConfiguration {
    private ConnectionMetrics metrics;

    public ConnectionFactory metrics(ConnectionMetrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public Connection build(Environment env, ExecutorService deliveryExecutor, String name) throws Exception {
        com.rabbitmq.client.ConnectionFactory connectionFactory = this.makeConnectionFactory();
        ConnectionMetrics connectionMetrics = (ConnectionMetrics)Optional.fromNullable((Object)this.metrics).or(() -> new DefaultConnectionMetrics(name, env.metrics()));
        Connection connection = connectionFactory.newConnection(deliveryExecutor);
        this.registerWithEnvironment(env, name, () -> connection);
        return new WrappedConnectionMetrics(connectionMetrics).wrap(connection);
    }

    public void buildRetryInitialConnect(Environment env, ExecutorService deliveryExecutor, String name, ConnectedCallback callback) throws Exception {
        com.rabbitmq.client.ConnectionFactory connectionFactory = this.makeConnectionFactory();
        ScheduledExecutorService initialConnectExecutor = env.lifecycle().scheduledExecutorService(name + "-initial-connect-thread").threads(1).build();
        ConnectionMetrics connectionMetrics = (ConnectionMetrics)Optional.fromNullable((Object)this.metrics).or(() -> new DefaultConnectionMetrics(name, env.metrics()));
        WrappedConnectionMetrics connectionMetricsWrapper = new WrappedConnectionMetrics(connectionMetrics);
        ConnectedCallback callbackWithMetrics = connection -> {
            Connection metricsConnection = connectionMetricsWrapper.wrap(connection);
            callback.connected(metricsConnection);
        };
        ConnectAsync connectAsync = new ConnectAsync(connectionFactory, deliveryExecutor, name, initialConnectExecutor, callbackWithMetrics);
        this.registerWithEnvironment(env, name, connectAsync::getConnection);
        connectAsync.run();
    }

    private void registerWithEnvironment(Environment env, String name, Supplier<Connection> connection) {
        env.healthChecks().register(name, (HealthCheck)new ConnectionHealthCheck(connection));
        env.lifecycle().manage((Managed)new ManageConnection(connection));
    }
}

