/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.producer;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.metric.HasFailureThresholds;
import io.codemonastery.dropwizard.kinesis.producer.NoOpClose;
import io.codemonastery.dropwizard.kinesis.producer.PutterMetrics;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ProducerMetrics
implements PutterMetrics,
HasFailureThresholds {
    private Meter partitionKeySuccessMeter;
    private Meter partitionKeyFailureMeter;
    private Meter encodeFailureMeter;
    private Meter encodeSuccessMeter;
    private Meter sentMeter;
    private Meter failedMeter;
    private Timer putRecordsTimer;
    private static final double failureFrequencyThreshold = 0.1;

    public static ProducerMetrics noOp() {
        return new ProducerMetrics(null, "");
    }

    public ProducerMetrics(MetricRegistry metrics, String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        if (metrics != null) {
            this.partitionKeySuccessMeter = metrics.meter(name + "-partition-key-success");
            this.partitionKeyFailureMeter = metrics.meter(name + "-partition-key-failure");
            this.encodeFailureMeter = metrics.meter(name + "-encode-failure");
            this.encodeSuccessMeter = metrics.meter(name + "-encode-success");
            this.sentMeter = metrics.meter(name + "-sent");
            this.failedMeter = metrics.meter(name + "-failed");
            this.putRecordsTimer = metrics.timer(name + "-put-records-time");
        }
    }

    public final void partitionKeyed() {
        if (this.partitionKeySuccessMeter != null) {
            this.partitionKeySuccessMeter.mark();
        }
    }

    public final void partitionKeyFailed() {
        if (this.partitionKeyFailureMeter != null) {
            this.partitionKeyFailureMeter.mark();
        }
    }

    public final void encodeFailed() {
        if (this.encodeFailureMeter != null) {
            this.encodeFailureMeter.mark();
        }
    }

    public void encoded() {
        if (this.encodeSuccessMeter != null) {
            this.encodeSuccessMeter.mark();
        }
    }

    @Override
    public final void sent(long successCount, long numFailedRecords) {
        if (this.sentMeter != null) {
            this.sentMeter.mark(successCount);
            this.failedMeter.mark(numFailedRecords);
        }
    }

    @Override
    public final Closeable time() {
        return this.putRecordsTimer == null ? NoOpClose.INSTANCE : this.putRecordsTimer.time();
    }

    @Override
    public List<String> highFailureMetrics() {
        double sendFailureFrequency;
        double encodeFailureFrequency;
        ArrayList<String> failed = new ArrayList<String>();
        double partitionKeyFailureFrequency = this.frequency(this.partitionKeySuccessMeter, this.partitionKeyFailureMeter, Meter::getOneMinuteRate);
        if (0.1 <= partitionKeyFailureFrequency) {
            failed.add(String.format("%.2f%% partition key failure", partitionKeyFailureFrequency * 100.0));
        }
        if (0.1 <= (encodeFailureFrequency = this.frequency(this.encodeSuccessMeter, this.encodeFailureMeter, Meter::getOneMinuteRate))) {
            failed.add(String.format("%.2f%% encode failure", encodeFailureFrequency * 100.0));
        }
        if (0.1 <= (sendFailureFrequency = this.frequency(this.sentMeter, this.failedMeter, Meter::getOneMinuteRate))) {
            failed.add(String.format("%.2f%% send failure", sendFailureFrequency * 100.0));
        }
        return failed;
    }

    private double frequency(Meter successMeter, Meter failureMeter, Function<Meter, Double> rate) {
        Double successRate = rate.apply(successMeter);
        Double failureRate = rate.apply(failureMeter);
        double totalRate = successRate + failureRate;
        return failureRate / totalRate;
    }
}

