/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.producer;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.EventEncoder;
import io.codemonastery.dropwizard.kinesis.StreamCreateConfiguration;
import io.codemonastery.dropwizard.kinesis.healthcheck.StreamHealthCheck;
import io.codemonastery.dropwizard.kinesis.producer.AbstractProducerFactory;
import io.codemonastery.dropwizard.kinesis.producer.BufferedProducer;
import io.codemonastery.dropwizard.kinesis.producer.BufferedProducerMetrics;
import io.codemonastery.dropwizard.kinesis.producer.SingletonBlockOnSubmitQueue;
import io.codemonastery.dropwizard.kinesis.producer.StreamFailureCheck;
import io.codemonastery.dropwizard.kinesis.producer.ratelimit.AcquireLimiterFactory;
import io.codemonastery.dropwizard.kinesis.producer.ratelimit.NoLimitAcquireLimiter;
import io.codemonastery.dropwizard.kinesis.producer.ratelimit.RateLimitedRecordPutter;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.util.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class BufferedProducerFactory<E>
extends AbstractProducerFactory<E> {
    @Min(value=1L)
    @Max(value=500L)
    private int maxBufferSize = 100;
    @Valid
    @NotNull
    private Duration flushPeriod = Duration.seconds((long)10L);

    @JsonProperty
    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    @JsonProperty
    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @JsonIgnore
    public BufferedProducerFactory<E> maxBufferSize(int maxBufferSize) {
        this.setMaxBufferSize(maxBufferSize);
        return this;
    }

    @JsonProperty
    public Duration getFlushPeriod() {
        return this.flushPeriod;
    }

    @JsonProperty
    public void setFlushPeriod(Duration flushPeriod) {
        this.flushPeriod = flushPeriod;
    }

    @JsonIgnore
    public BufferedProducerFactory<E> flushPeriod(Duration flushPeriod) {
        this.setFlushPeriod(flushPeriod);
        return this;
    }

    @Override
    public BufferedProducerFactory<E> streamName(String streamName) {
        super.streamName(streamName);
        return this;
    }

    @Override
    public BufferedProducerFactory<E> partitionKeyFn(Function<E, String> partitionKeyFn) {
        super.partitionKeyFn(partitionKeyFn);
        return this;
    }

    @Override
    public BufferedProducerFactory<E> encoder(EventEncoder<E> encoder) {
        super.encoder(encoder);
        return this;
    }

    @JsonIgnore
    public BufferedProducerFactory<E> create(StreamCreateConfiguration create) {
        this.setCreate(create);
        return this;
    }

    @Override
    public BufferedProducerFactory<E> rateLimit(AcquireLimiterFactory rateLimit) {
        super.rateLimit(rateLimit);
        return this;
    }

    @Override
    @JsonIgnore
    public BufferedProducer<E> build(MetricRegistry metrics, HealthCheckRegistry healthChecks, LifecycleEnvironment lifecycle, AmazonKinesis kinesis, String name) {
        ScheduledExecutorService flushExecutor;
        ExecutorService deliveryExecutor;
        Preconditions.checkNotNull((Object)this.encoder, (Object)"encoder cannot be null, was not inferred");
        Preconditions.checkNotNull((Object)this.partitionKeyFn, (Object)"partitionKeyFn cannot be null, is allowed to return null");
        Preconditions.checkNotNull((Object)this.flushPeriod, (Object)"flushPeriod cannot be null");
        Preconditions.checkArgument((this.flushPeriod.getQuantity() > 0L ? 1 : 0) != 0, (Object)"flush period must be positive");
        Preconditions.checkState((boolean)super.setupStream(kinesis), (Object)String.format("stream %s was not setup successfully", this.getStreamName()));
        if (lifecycle != null) {
            deliveryExecutor = lifecycle.executorService(name + "-delivery-executor-%d").workQueue((BlockingQueue)new SingletonBlockOnSubmitQueue()).minThreads(1).maxThreads(1).build();
            flushExecutor = lifecycle.scheduledExecutorService(name + "-flush-executor-%d").threads(1).build();
        } else {
            deliveryExecutor = Executors.newSingleThreadExecutor();
            flushExecutor = Executors.newScheduledThreadPool(1);
        }
        BufferedProducerMetrics producerMetrics = new BufferedProducerMetrics(metrics, name);
        if (healthChecks != null) {
            healthChecks.register(name, (HealthCheck)new StreamFailureCheck(producerMetrics, new StreamHealthCheck(kinesis, this.getStreamName())));
        }
        BufferedProducer producer = new BufferedProducer(this.getStreamName(), this.partitionKeyFn, this.encoder, this.maxBufferSize, deliveryExecutor, producerMetrics, new RateLimitedRecordPutter(kinesis, producerMetrics, ((AcquireLimiterFactory)Optional.fromNullable((Object)this.rateLimit).or(NoLimitAcquireLimiter::new)).build()));
        if (lifecycle != null) {
            lifecycle.manage(producer);
        }
        flushExecutor.scheduleAtFixedRate(producer::flush, this.flushPeriod.toMilliseconds(), this.flushPeriod.toMilliseconds(), TimeUnit.MILLISECONDS);
        return producer;
    }
}

