/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.healthcheck;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.codahale.metrics.health.HealthCheck;

public class StreamHealthCheck
extends HealthCheck {
    private final AmazonKinesis kinesis;
    private final String streamName;

    public StreamHealthCheck(AmazonKinesis kinesis, String streamName) {
        this.kinesis = kinesis;
        this.streamName = streamName;
    }

    protected HealthCheck.Result check() throws Exception {
        HealthCheck.Result result = HealthCheck.Result.healthy();
        try {
            DescribeStreamResult describeResult = this.kinesis.describeStream(this.streamName);
            if (describeResult == null || describeResult.getStreamDescription() == null || !"active".equalsIgnoreCase(describeResult.getStreamDescription().getStreamStatus())) {
                result = HealthCheck.Result.unhealthy((String)(this.streamName + " exists but is not active"));
            }
        }
        catch (ResourceNotFoundException e) {
            result = HealthCheck.Result.unhealthy((String)(this.streamName + " does not exist"));
        }
        catch (Exception e) {
            result = HealthCheck.Result.unhealthy((Throwable)new Exception("could not check status of stream", e));
        }
        return result;
    }
}

