/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.StreamCreateConfiguration;
import javax.validation.Valid;
import org.hibernate.validator.constraints.NotEmpty;

public class StreamConfiguration {
    @NotEmpty
    private String streamName;
    @Valid
    private StreamCreateConfiguration create;

    @JsonProperty
    public String getStreamName() {
        return this.streamName;
    }

    @JsonProperty
    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    @JsonProperty
    public StreamCreateConfiguration getCreate() {
        return this.create;
    }

    @JsonProperty
    public void setCreate(StreamCreateConfiguration create) {
        this.create = create;
    }

    @JsonIgnore
    protected boolean setupStream(AmazonKinesis kinesis) {
        Preconditions.checkNotNull((Object)this.streamName, (Object)"stream name cannot be null");
        boolean setup = true;
        if (this.create != null) {
            setup = this.create.setupStream(kinesis, this.streamName);
        }
        return setup;
    }
}

