/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.EventDecoder;
import io.codemonastery.dropwizard.kinesis.EventEncoder;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public final class EventObjectMapper<E>
implements EventEncoder<E>,
EventDecoder<E> {
    private final ObjectMapper objectMapper;
    private final Class<E> klass;

    public EventObjectMapper(ObjectMapper objectMapper, @Nullable Class<E> klass) {
        Preconditions.checkNotNull((Object)objectMapper);
        this.objectMapper = objectMapper;
        this.klass = klass;
    }

    @Override
    @Nullable
    public E decode(ByteBuffer bytes) throws Exception {
        if (this.klass == null) {
            throw new UnsupportedOperationException("cannot decode if event class was not specified");
        }
        return (E)this.objectMapper.readValue(bytes.array(), this.klass);
    }

    @Override
    @Nullable
    public byte[] encode(E event) throws Exception {
        return this.objectMapper.writeValueAsBytes(event);
    }
}

