/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxyExtended;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.ExpiredIteratorException;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.InvalidArgumentException;
import com.amazonaws.services.kinesis.model.LimitExceededException;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.StreamStatus;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleKinesisProxy
implements IKinesisProxyExtended {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleKinesisProxy.class);
    private static final long DEFAULT_DESCRIBE_STREAM_BACKOFF_MILLIS = 1000L;
    private static final int DEFAULT_DESCRIBE_STREAM_RETRY_TIMES = 50;
    private final AmazonKinesis client;
    private final String streamName;
    private final long describeStreamBackoffTimeInMillis;
    private final int maxDescribeStreamRetryAttempts;
    private AtomicReference<List<Shard>> listOfShardsSinceLastGet = new AtomicReference();

    public SimpleKinesisProxy(AmazonKinesis client, String streamName) {
        this(client, streamName, 1000L, 50);
    }

    public SimpleKinesisProxy(AmazonKinesis client, String streamName, long describeStreamBackoffTimeInMillis, int maxDescribeStreamRetryAttempts) {
        this.client = client;
        this.streamName = streamName;
        this.describeStreamBackoffTimeInMillis = describeStreamBackoffTimeInMillis;
        this.maxDescribeStreamRetryAttempts = maxDescribeStreamRetryAttempts;
    }

    public GetRecordsResult get(String shardIterator, int maxRecords) throws ResourceNotFoundException, InvalidArgumentException, ExpiredIteratorException {
        GetRecordsRequest getRecordsRequest = new GetRecordsRequest();
        getRecordsRequest.setShardIterator(shardIterator);
        getRecordsRequest.setLimit(Integer.valueOf(maxRecords));
        return this.client.getRecords(getRecordsRequest);
    }

    public DescribeStreamResult getStreamInfo(String startShardId) throws ResourceNotFoundException, LimitExceededException {
        DescribeStreamRequest describeStreamRequest = new DescribeStreamRequest();
        describeStreamRequest.setStreamName(this.streamName);
        describeStreamRequest.setExclusiveStartShardId(startShardId);
        DescribeStreamResult response = null;
        for (int remainingRetryTimes = this.maxDescribeStreamRetryAttempts; remainingRetryTimes >= 0 && response == null; --remainingRetryTimes) {
            try {
                response = this.client.describeStream(describeStreamRequest);
                continue;
            }
            catch (LimitExceededException le) {
                LOG.info("Got LimitExceededException when describing stream " + this.streamName + ". Backing off for " + this.describeStreamBackoffTimeInMillis + " millis.");
                try {
                    Thread.sleep(this.describeStreamBackoffTimeInMillis);
                    continue;
                }
                catch (InterruptedException ie) {
                    LOG.debug("Stream " + this.streamName + " : Sleep  was interrupted ", (Throwable)ie);
                }
            }
        }
        if (response != null) {
            if (StreamStatus.ACTIVE.toString().equals(response.getStreamDescription().getStreamStatus()) || StreamStatus.UPDATING.toString().equals(response.getStreamDescription().getStreamStatus())) {
                return response;
            }
            LOG.info("Stream is in status " + response.getStreamDescription().getStreamStatus() + ", KinesisProxy.DescribeStream returning null (wait until stream is Active or Updating");
        }
        return null;
    }

    public Shard getShard(String shardId) {
        List<Shard> shards = this.getListOfShardsSinceLastGet();
        if (shards == null) {
            shards = this.getShardList();
        }
        for (Shard shard : shards) {
            if (!shard.getShardId().equals(shardId)) continue;
            return shard;
        }
        LOG.warn("Cannot find the shard given the shardId " + shardId);
        return null;
    }

    public List<Shard> getShardList() {
        DescribeStreamResult response;
        ArrayList<Shard> result = new ArrayList<Shard>();
        String lastShardId = null;
        do {
            if ((response = this.getStreamInfo(lastShardId)) == null) {
                return null;
            }
            List shards = response.getStreamDescription().getShards();
            result.addAll(shards);
            lastShardId = ((Shard)shards.get(shards.size() - 1)).getShardId();
        } while (response.getStreamDescription().isHasMoreShards().booleanValue());
        this.updateShardsSinceLastGet(result);
        return result;
    }

    public Set<String> getAllShardIds() throws ResourceNotFoundException {
        List<Shard> shards = this.getShardList();
        Set shardIds = shards == null ? null : this.getShardList().stream().map(Shard::getShardId).collect(Collectors.toSet());
        return shardIds;
    }

    public String getIterator(String shardId, String iteratorType, String sequenceNumber) {
        GetShardIteratorRequest getShardIteratorRequest = new GetShardIteratorRequest();
        getShardIteratorRequest.setStreamName(this.streamName);
        getShardIteratorRequest.setShardId(shardId);
        getShardIteratorRequest.setShardIteratorType(iteratorType);
        getShardIteratorRequest.setStartingSequenceNumber(sequenceNumber);
        GetShardIteratorResult response = this.client.getShardIterator(getShardIteratorRequest);
        return response.getShardIterator();
    }

    public PutRecordResult put(String exclusiveMinimumSequenceNumber, String explicitHashKey, String partitionKey, ByteBuffer data) throws ResourceNotFoundException, InvalidArgumentException {
        PutRecordRequest putRecordRequest = new PutRecordRequest();
        putRecordRequest.setStreamName(this.streamName);
        putRecordRequest.setSequenceNumberForOrdering(exclusiveMinimumSequenceNumber);
        putRecordRequest.setExplicitHashKey(explicitHashKey);
        putRecordRequest.setPartitionKey(partitionKey);
        putRecordRequest.setData(data);
        return this.client.putRecord(putRecordRequest);
    }

    List<Shard> getListOfShardsSinceLastGet() {
        return this.listOfShardsSinceLastGet.get();
    }

    void updateShardsSinceLastGet(List<Shard> result) {
        this.listOfShardsSinceLastGet.set(result);
    }
}

