/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.producer;

import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.EventEncoder;
import io.codemonastery.dropwizard.kinesis.producer.ProducerMetrics;
import io.dropwizard.lifecycle.Managed;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Producer<E>
implements Managed {
    public static final int MAX_RECORD_SIZE = 0x100000;
    public static final int MAX_REQUEST_SIZE = 0x500000;
    private static final Logger LOG = LoggerFactory.getLogger(Producer.class);
    private volatile boolean shutdown = false;
    private final EventEncoder<E> encoder;
    private final Function<E, String> partitionKeyFn;
    protected final ProducerMetrics metrics;

    public Producer(Function<E, String> partitionKeyFn, EventEncoder<E> encoder, ProducerMetrics metrics) {
        Preconditions.checkNotNull(encoder, (Object)"encoder cannot be null");
        Preconditions.checkNotNull(partitionKeyFn, (Object)"partitionKeyFn cannot be null");
        Preconditions.checkNotNull((Object)metrics, (Object)"metrics cannot be null");
        this.encoder = encoder;
        this.partitionKeyFn = partitionKeyFn;
        this.metrics = metrics;
    }

    public void sendAll(List<E> events) throws Exception {
        for (E event : events) {
            this.send(event);
        }
    }

    public final void send(E event) throws Exception {
        this.assertNotShutdownForSend();
        byte[] bytes = null;
        try {
            bytes = this.encoder.encode(event);
            this.metrics.encoded();
        }
        catch (Exception e) {
            this.metrics.encodeFailed();
            LOG.error("could not encode event " + event.toString());
        }
        if (bytes == null) {
            LOG.warn("skipping event " + event + " because could not be encoded or was null");
        } else if (bytes.length > 0x100000) {
            this.metrics.encodeFailed();
            LOG.error(String.format("skipping event because encoded size was %.2f MB, larger than max record size", (double)bytes.length / 1048576.0));
        } else {
            String partitionKey = null;
            try {
                partitionKey = this.partitionKeyFn.apply(event);
            }
            catch (Exception e) {
                this.metrics.partitionKeyFailed();
                LOG.error("Unexpected exception while calculating partition key for event " + event.toString(), (Throwable)e);
            }
            if (partitionKey == null) {
                LOG.warn("skipping event " + event + " because partition key could not be calculated or was null");
            } else {
                PutRecordsRequestEntry record = new PutRecordsRequestEntry().withData(ByteBuffer.wrap(bytes)).withPartitionKey(partitionKey);
                record = this.extra(record, event);
                this.send(record);
            }
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.shutdown = true;
    }

    protected PutRecordsRequestEntry extra(PutRecordsRequestEntry record, E event) {
        return record;
    }

    protected abstract void send(PutRecordsRequestEntry var1) throws Exception;

    private void assertNotShutdownForSend() {
        if (this.shutdown) {
            throw new IllegalStateException("cannot send more events because producer has been shutdown");
        }
    }
}

