/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.healthcheck;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.healthcheck.DynamoDbClientHealthCheckFactory;

public class ListTablesHealthCheckFactory
implements DynamoDbClientHealthCheckFactory {
    @Override
    public HealthCheck build(AmazonDynamoDB client) {
        Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
        return new HealthCheck(client);
    }

    private static class HealthCheck
    extends com.codahale.metrics.health.HealthCheck {
        private final AmazonDynamoDB client;

        public HealthCheck(AmazonDynamoDB client) {
            this.client = client;
        }

        protected HealthCheck.Result check() throws Exception {
            HealthCheck.Result result;
            try {
                this.client.listTables();
                result = HealthCheck.Result.healthy();
            }
            catch (Exception e) {
                result = HealthCheck.Result.unhealthy((Throwable)e);
            }
            return result;
        }
    }
}

