/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.healthcheck;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;

public class KinesisClientHealthCheck
extends HealthCheck {
    private final AmazonKinesis client;

    public KinesisClientHealthCheck(AmazonKinesis client) {
        Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
        this.client = client;
    }

    protected HealthCheck.Result check() throws Exception {
        HealthCheck.Result result;
        try {
            this.client.listStreams();
            result = HealthCheck.Result.healthy();
        }
        catch (Exception e) {
            result = HealthCheck.Result.unhealthy((Throwable)e);
        }
        return result;
    }
}

