/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.healthcheck;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.healthcheck.DynamoDbClientHealthCheckFactory;
import javax.validation.Valid;
import org.hibernate.validator.constraints.NotEmpty;

public class DescribeTableHealthCheckFactory
implements DynamoDbClientHealthCheckFactory {
    @Valid
    @NotEmpty
    private String tableName = "test";
    @Valid
    private boolean tableMustExist = false;

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @JsonIgnore
    public DescribeTableHealthCheckFactory tableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    @JsonProperty
    public boolean isTableMustExist() {
        return this.tableMustExist;
    }

    @JsonProperty
    public void setTableMustExist(boolean tableMustExist) {
        this.tableMustExist = tableMustExist;
    }

    @JsonIgnore
    public DescribeTableHealthCheckFactory tableMustExist(boolean tableMustExist) {
        this.setTableMustExist(tableMustExist);
        return this;
    }

    @Override
    public HealthCheck build(AmazonDynamoDB client) {
        Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
        Preconditions.checkNotNull((Object)this.getTableName(), (Object)"tableName must be specified");
        return new MyHealthCheck(client, this.getTableName(), this.isTableMustExist());
    }

    private static class MyHealthCheck
    extends HealthCheck {
        private final AmazonDynamoDB client;
        private final String tableName;
        private final boolean tableMustExist;

        public MyHealthCheck(AmazonDynamoDB client, String tableName, boolean tableMustExist) {
            this.client = client;
            this.tableName = tableName;
            this.tableMustExist = tableMustExist;
        }

        protected HealthCheck.Result check() throws Exception {
            HealthCheck.Result result = HealthCheck.Result.healthy();
            try {
                this.client.describeTable(this.tableName);
            }
            catch (ResourceNotFoundException e) {
                if (this.tableMustExist) {
                    String message = String.format("table %s does not exist, was configured to require table existing", this.tableName);
                    result = HealthCheck.Result.unhealthy((String)message);
                }
            }
            catch (Exception e) {
                result = HealthCheck.Result.unhealthy((Throwable)e);
            }
            return result;
        }
    }
}

