/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.consumer;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.StreamConfiguration;
import io.dropwizard.util.Duration;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class KinesisClientLibConfig
extends StreamConfiguration {
    private String applicationName;
    private String workerId;
    @NotNull
    private InitialPositionInStream initialPositionInStream = InitialPositionInStream.LATEST;
    @Valid
    @NotNull
    private Duration failOverTime = Duration.milliseconds((long)10000L);
    @Min(value=1L)
    private int maxRecords = 10000;
    @Valid
    @NotNull
    private Duration idleTimeBetweenReads = Duration.milliseconds((long)1000L);
    private boolean callIfEmpty = false;
    @Valid
    @NotNull
    private Duration parentShardPollInterval = Duration.milliseconds((long)10000L);
    @Valid
    @NotNull
    private Duration shardSyncInterval = Duration.milliseconds((long)60000L);
    private boolean cleanupLeasesOnShardCompletion = true;
    @Valid
    @NotNull
    private Duration taskBackoffTime = Duration.milliseconds((long)500L);
    private boolean validateSequenceNumberBeforeCheckpoint = true;

    @JsonProperty
    public String getApplicationName() {
        return this.applicationName;
    }

    @JsonProperty
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @JsonProperty
    public String getWorkerId() {
        return this.workerId;
    }

    @JsonProperty
    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    @JsonProperty
    public InitialPositionInStream getInitialPositionInStream() {
        return this.initialPositionInStream;
    }

    @JsonProperty
    public void setInitialPositionInStream(InitialPositionInStream initialPositionInStream) {
        this.initialPositionInStream = initialPositionInStream;
    }

    @JsonProperty
    public Duration getFailOverTime() {
        return this.failOverTime;
    }

    @JsonProperty
    public void setFailOverTime(Duration failOverTime) {
        this.failOverTime = failOverTime;
    }

    @JsonProperty
    public int getMaxRecords() {
        return this.maxRecords;
    }

    @JsonProperty
    public void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    @JsonProperty
    public Duration getIdleTimeBetweenReads() {
        return this.idleTimeBetweenReads;
    }

    @JsonProperty
    public void setIdleTimeBetweenReads(Duration idleTimeBetweenReads) {
        this.idleTimeBetweenReads = idleTimeBetweenReads;
    }

    @JsonProperty
    public boolean isCallIfEmpty() {
        return this.callIfEmpty;
    }

    @JsonProperty
    public void setCallIfEmpty(boolean callIfEmpty) {
        this.callIfEmpty = callIfEmpty;
    }

    @JsonProperty
    public Duration getParentShardPollInterval() {
        return this.parentShardPollInterval;
    }

    @JsonProperty
    public void setParentShardPollInterval(Duration parentShardPollInterval) {
        this.parentShardPollInterval = parentShardPollInterval;
    }

    @JsonProperty
    public Duration getShardSyncInterval() {
        return this.shardSyncInterval;
    }

    @JsonProperty
    public void setShardSyncInterval(Duration shardSyncInterval) {
        this.shardSyncInterval = shardSyncInterval;
    }

    @JsonProperty
    public boolean isCleanupLeasesOnShardCompletion() {
        return this.cleanupLeasesOnShardCompletion;
    }

    @JsonProperty
    public void setCleanupLeasesOnShardCompletion(boolean cleanupLeasesOnShardCompletion) {
        this.cleanupLeasesOnShardCompletion = cleanupLeasesOnShardCompletion;
    }

    @JsonProperty
    public Duration getTaskBackoffTime() {
        return this.taskBackoffTime;
    }

    @JsonProperty
    public void setTaskBackoffTime(Duration taskBackoffTime) {
        this.taskBackoffTime = taskBackoffTime;
    }

    @JsonProperty
    public boolean isValidateSequenceNumberBeforeCheckpoint() {
        return this.validateSequenceNumberBeforeCheckpoint;
    }

    @JsonProperty
    public void setValidateSequenceNumberBeforeCheckpoint(boolean validateSequenceNumberBeforeCheckpoint) {
        this.validateSequenceNumberBeforeCheckpoint = validateSequenceNumberBeforeCheckpoint;
    }

    KinesisClientLibConfiguration makeKinesisClientLibConfiguration(String name) {
        Preconditions.checkNotNull((Object)this.getStreamName(), (Object)"streamName cannot be null");
        Preconditions.checkNotNull((Object)this.initialPositionInStream, (Object)"initialPositionInStream cannot be null");
        Preconditions.checkNotNull((Object)this.failOverTime, (Object)"failOverTime cannot be null");
        Preconditions.checkNotNull((Object)this.idleTimeBetweenReads, (Object)"idleTimeBetweenReads cannot be null");
        Preconditions.checkNotNull((Object)this.parentShardPollInterval, (Object)"parentShardPollInterval cannot be null");
        Preconditions.checkNotNull((Object)this.shardSyncInterval, (Object)"shardSyncInterval cannot be null");
        Preconditions.checkNotNull((Object)this.taskBackoffTime, (Object)"taskBackoffTime cannot be null");
        ClientConfiguration unusedConfig = new ClientConfiguration();
        return new KinesisClientLibConfiguration((String)Optional.fromNullable((Object)this.getApplicationName()).or((Object)name), this.getStreamName(), null, this.getInitialPositionInStream(), null, null, null, this.getFailOverTime().toMilliseconds(), (String)Optional.fromNullable((Object)this.getWorkerId()).or((Object)name), this.getMaxRecords(), this.getIdleTimeBetweenReads().toMilliseconds(), this.isCallIfEmpty(), this.getParentShardPollInterval().toMilliseconds(), this.getShardSyncInterval().toMilliseconds(), this.isCleanupLeasesOnShardCompletion(), unusedConfig, unusedConfig, unusedConfig, this.getTaskBackoffTime().toMilliseconds(), 10000L, 10000, this.isValidateSequenceNumberBeforeCheckpoint(), null);
    }
}

