/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.producer.ratelimit;

import com.google.common.util.concurrent.RateLimiter;
import io.codemonastery.dropwizard.kinesis.producer.ratelimit.AcquireLimiter;

public class DynamicAcquireLimiter
implements AcquireLimiter {
    private final double backoffDivisor;
    private final double moveForwardAddend;
    private final RateLimiter rateLimiter;

    public static DynamicAcquireLimiter create(double initialPermitsPerSecond) {
        return DynamicAcquireLimiter.create(initialPermitsPerSecond, 2.0, 0.016666666666666666);
    }

    public static DynamicAcquireLimiter create(double initialPermitsPerSecond, double backoffDivisor, double moveForwardAddend) {
        return new DynamicAcquireLimiter(initialPermitsPerSecond, backoffDivisor, moveForwardAddend);
    }

    DynamicAcquireLimiter(double initialPermitsPerSecond, double backoffDivisor, double moveForwardAddend) {
        this.backoffDivisor = backoffDivisor;
        this.moveForwardAddend = moveForwardAddend;
        this.rateLimiter = RateLimiter.create((double)initialPermitsPerSecond);
    }

    @Override
    public double acquire(int permits) {
        return this.rateLimiter.acquire(permits);
    }

    @Override
    public void update(int size, int rateExceededCount) {
        if (rateExceededCount > 0) {
            this.backOff();
        } else {
            this.moveForward();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backOff() {
        RateLimiter rateLimiter = this.rateLimiter;
        synchronized (rateLimiter) {
            double newRate = this.rateLimiter.getRate() / this.backoffDivisor;
            this.rateLimiter.setRate(newRate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveForward() {
        RateLimiter rateLimiter = this.rateLimiter;
        synchronized (rateLimiter) {
            double newRate = this.rateLimiter.getRate() + this.moveForwardAddend;
            this.rateLimiter.setRate(newRate);
        }
    }
}

