/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.producer;

import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.EventEncoder;
import io.codemonastery.dropwizard.kinesis.producer.Producer;
import io.codemonastery.dropwizard.kinesis.producer.ProducerMetrics;
import io.codemonastery.dropwizard.kinesis.producer.RecordPutter;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleProducer<E>
extends Producer<E> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleProducer.class);
    private final String streamName;
    private final RecordPutter putter;

    public SimpleProducer(String streamName, Function<E, String> partitionKeyFn, EventEncoder<E> encoder, ProducerMetrics metrics, RecordPutter putter) {
        super(partitionKeyFn, encoder, metrics);
        Preconditions.checkNotNull((Object)streamName, (Object)"streamName cannot be null");
        Preconditions.checkNotNull((Object)putter, (Object)"putter cannot be null");
        this.streamName = streamName;
        this.putter = putter;
    }

    @Override
    protected void send(PutRecordsRequestEntry record) throws Exception {
        PutRecordsRequest request = new PutRecordsRequest().withRecords(new PutRecordsRequestEntry[]{record}).withStreamName(this.streamName);
        int failedCount = this.putter.send(request);
        if (LOG.isDebugEnabled()) {
            String message = String.format("Put %d records to stream %s, %d failed", request.getRecords().size(), this.streamName, failedCount);
            LOG.debug(message);
        }
    }
}

