/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.producer;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.producer.ProducerMetrics;

public class BufferedProducerMetrics
extends ProducerMetrics {
    private Meter bufferPutMeter;
    private Counter bufferSizeCounter;

    public BufferedProducerMetrics(MetricRegistry metrics, String name) {
        super(metrics, name);
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        if (metrics != null) {
            this.bufferPutMeter = metrics.meter(name + "-buffer-put");
            this.bufferSizeCounter = metrics.counter(name + "-buffer-size");
        }
    }

    public final void bufferPut(int n) {
        if (this.bufferPutMeter != null) {
            this.bufferPutMeter.mark((long)n);
            this.bufferSizeCounter.inc((long)n);
        }
    }

    public final void bufferRemove(int n) {
        if (this.bufferSizeCounter != null) {
            this.bufferSizeCounter.dec((long)n);
        }
    }
}

