/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.producer;

import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.codemonastery.dropwizard.kinesis.EventEncoder;
import io.codemonastery.dropwizard.kinesis.producer.BufferedProducerMetrics;
import io.codemonastery.dropwizard.kinesis.producer.Producer;
import io.codemonastery.dropwizard.kinesis.producer.PutRecordsBuffer;
import io.codemonastery.dropwizard.kinesis.producer.RecordPutter;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferedProducer<E>
extends Producer<E> {
    private static final Logger LOG = LoggerFactory.getLogger(BufferedProducer.class);
    private final String streamName;
    private final ExecutorService deliveryExecutor;
    private final BufferedProducerMetrics bufferedMetrics;
    private final PutRecordsBuffer buffer;
    private final RecordPutter putter;

    public BufferedProducer(String streamName, Function<E, String> partitionKeyFn, EventEncoder<E> encoder, int maxBufferSize, ExecutorService deliveryExecutor, BufferedProducerMetrics metrics, RecordPutter putter) {
        super(partitionKeyFn, encoder, metrics);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)streamName) ? 1 : 0) != 0, (Object)"must have a stream name");
        Preconditions.checkArgument((maxBufferSize > 0 ? 1 : 0) != 0, (Object)"maxBufferSize must be positive");
        Preconditions.checkNotNull((Object)deliveryExecutor, (Object)"must have a delivery executor");
        Preconditions.checkNotNull((Object)putter, (Object)"putter cannot be null");
        this.streamName = streamName;
        this.deliveryExecutor = deliveryExecutor;
        this.bufferedMetrics = metrics;
        this.buffer = new PutRecordsBuffer(maxBufferSize);
        this.putter = putter;
    }

    public void flush() {
        try {
            List<PutRecordsRequestEntry> submitMe = this.buffer.drain();
            this.bufferedMetrics.bufferRemove(submitMe.size());
            if (!submitMe.isEmpty()) {
                List<PutRecordsRequestEntry> temp = submitMe;
                this.deliveryExecutor.submit(() -> this.putRecords(temp));
            }
        }
        catch (Exception e) {
            LOG.error("unexpected error while flushing", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        PutRecordsBuffer putRecordsBuffer = this.buffer;
        synchronized (putRecordsBuffer) {
            super.stop();
            this.putRecords(this.buffer.drain());
        }
    }

    @Override
    protected void send(PutRecordsRequestEntry record) {
        List<PutRecordsRequestEntry> submitMe = this.buffer.add(record);
        if (submitMe != null) {
            this.bufferedMetrics.bufferRemove(submitMe.size());
        }
        this.bufferedMetrics.bufferPut(1);
        if (submitMe != null) {
            List<PutRecordsRequestEntry> temp = submitMe;
            this.deliveryExecutor.submit(() -> this.putRecords(temp));
        }
    }

    private void putRecords(List<PutRecordsRequestEntry> records) {
        try {
            if (records != null && !records.isEmpty()) {
                PutRecordsRequest request = new PutRecordsRequest().withRecords(records).withStreamName(this.streamName);
                int failedCount = this.putter.send(request);
                if (LOG.isDebugEnabled()) {
                    String message = String.format("Put %d records to stream %s, %d failed", request.getRecords().size(), this.streamName, failedCount);
                    LOG.debug(message);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unexpected exception putting records", (Throwable)e);
        }
    }
}

