/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.metric;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.regions.Region;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.services.dynamodbv2.waiters.AmazonDynamoDBWaiters;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.List;
import java.util.Map;

public class DynamoDbMetricsProxy
implements AmazonDynamoDB {
    private final AmazonDynamoDB delegate;
    private final Timer batchGetItemTimer;
    private final Timer batchWriteItemTimer;
    private final Timer createTableTimer;
    private final Timer deleteItemTimer;
    private final Timer deleteTableTimer;
    private final Timer describeTableTimer;
    private final Timer getItemTimer;
    private final Timer listTablesTimer;
    private final Timer putItemTimer;
    private final Timer queryTimer;
    private final Timer scanTimer;
    private final Timer updateItemTimer;
    private final Timer updateTableTimer;
    private final Timer describeLimitsTimer;

    public DynamoDbMetricsProxy(AmazonDynamoDB delegate, MetricRegistry metrics, String name) {
        this.delegate = delegate;
        this.batchGetItemTimer = metrics.timer(name + "-get-item-batch");
        this.batchWriteItemTimer = metrics.timer(name + "-write-item-batch");
        this.createTableTimer = metrics.timer(name + "-create-table");
        this.deleteItemTimer = metrics.timer(name + "-delete-item");
        this.deleteTableTimer = metrics.timer(name + "-delete-table");
        this.describeTableTimer = metrics.timer(name + "-describe-table");
        this.getItemTimer = metrics.timer(name + "-get-item");
        this.listTablesTimer = metrics.timer(name + "-list-tables");
        this.putItemTimer = metrics.timer(name + "-put-item");
        this.queryTimer = metrics.timer(name + "-query");
        this.scanTimer = metrics.timer(name + "-scan");
        this.updateItemTimer = metrics.timer(name + "-update-item");
        this.updateTableTimer = metrics.timer(name + "-update-table");
        this.describeLimitsTimer = metrics.timer(name + "-describe-limits");
    }

    public void setEndpoint(String s) {
        this.delegate.setEndpoint(s);
    }

    public void setRegion(Region region) {
        this.delegate.setRegion(region);
    }

    public BatchGetItemResult batchGetItem(BatchGetItemRequest batchGetItemRequest) {
        try (Timer.Context ignored = this.batchGetItemTimer.time();){
            BatchGetItemResult batchGetItemResult = this.delegate.batchGetItem(batchGetItemRequest);
            return batchGetItemResult;
        }
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> map, String s) {
        try (Timer.Context ignored = this.batchGetItemTimer.time();){
            BatchGetItemResult batchGetItemResult = this.delegate.batchGetItem(map, s);
            return batchGetItemResult;
        }
    }

    public BatchGetItemResult batchGetItem(Map<String, KeysAndAttributes> map) {
        try (Timer.Context ignored = this.batchGetItemTimer.time();){
            BatchGetItemResult batchGetItemResult = this.delegate.batchGetItem(map);
            return batchGetItemResult;
        }
    }

    public BatchWriteItemResult batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) {
        try (Timer.Context ignored = this.batchWriteItemTimer.time();){
            BatchWriteItemResult batchWriteItemResult = this.delegate.batchWriteItem(batchWriteItemRequest);
            return batchWriteItemResult;
        }
    }

    public BatchWriteItemResult batchWriteItem(Map<String, List<WriteRequest>> map) {
        try (Timer.Context ignored = this.batchWriteItemTimer.time();){
            BatchWriteItemResult batchWriteItemResult = this.delegate.batchWriteItem(map);
            return batchWriteItemResult;
        }
    }

    public CreateTableResult createTable(CreateTableRequest createTableRequest) {
        try (Timer.Context ignored = this.createTableTimer.time();){
            CreateTableResult createTableResult = this.delegate.createTable(createTableRequest);
            return createTableResult;
        }
    }

    public CreateTableResult createTable(List<AttributeDefinition> list, String s, List<KeySchemaElement> list1, ProvisionedThroughput provisionedThroughput) {
        try (Timer.Context ignored = this.createTableTimer.time();){
            CreateTableResult createTableResult = this.delegate.createTable(list, s, list1, provisionedThroughput);
            return createTableResult;
        }
    }

    public DeleteItemResult deleteItem(DeleteItemRequest deleteItemRequest) {
        try (Timer.Context ignored = this.deleteItemTimer.time();){
            DeleteItemResult deleteItemResult = this.delegate.deleteItem(deleteItemRequest);
            return deleteItemResult;
        }
    }

    public DeleteItemResult deleteItem(String s, Map<String, AttributeValue> map) {
        try (Timer.Context ignored = this.deleteItemTimer.time();){
            DeleteItemResult deleteItemResult = this.delegate.deleteItem(s, map);
            return deleteItemResult;
        }
    }

    public DeleteItemResult deleteItem(String s, Map<String, AttributeValue> map, String s1) {
        try (Timer.Context ignored = this.deleteItemTimer.time();){
            DeleteItemResult deleteItemResult = this.delegate.deleteItem(s, map, s1);
            return deleteItemResult;
        }
    }

    public DeleteTableResult deleteTable(DeleteTableRequest deleteTableRequest) {
        try (Timer.Context ignored = this.deleteTableTimer.time();){
            DeleteTableResult deleteTableResult = this.delegate.deleteTable(deleteTableRequest);
            return deleteTableResult;
        }
    }

    public DeleteTableResult deleteTable(String s) {
        try (Timer.Context ignored = this.deleteTableTimer.time();){
            DeleteTableResult deleteTableResult = this.delegate.deleteTable(s);
            return deleteTableResult;
        }
    }

    public DescribeLimitsResult describeLimits(DescribeLimitsRequest describeLimitsRequest) {
        try (Timer.Context ignored = this.describeLimitsTimer.time();){
            DescribeLimitsResult describeLimitsResult = this.delegate.describeLimits(describeLimitsRequest);
            return describeLimitsResult;
        }
    }

    public DescribeTableResult describeTable(DescribeTableRequest describeTableRequest) {
        try (Timer.Context ignored = this.describeTableTimer.time();){
            DescribeTableResult describeTableResult = this.delegate.describeTable(describeTableRequest);
            return describeTableResult;
        }
    }

    public DescribeTableResult describeTable(String s) {
        try (Timer.Context ignored = this.describeTableTimer.time();){
            DescribeTableResult describeTableResult = this.delegate.describeTable(s);
            return describeTableResult;
        }
    }

    public GetItemResult getItem(GetItemRequest getItemRequest) {
        try (Timer.Context ignored = this.getItemTimer.time();){
            GetItemResult getItemResult = this.delegate.getItem(getItemRequest);
            return getItemResult;
        }
    }

    public GetItemResult getItem(String s, Map<String, AttributeValue> map) {
        try (Timer.Context ignored = this.getItemTimer.time();){
            GetItemResult getItemResult = this.delegate.getItem(s, map);
            return getItemResult;
        }
    }

    public GetItemResult getItem(String s, Map<String, AttributeValue> map, Boolean aBoolean) {
        try (Timer.Context ignored = this.getItemTimer.time();){
            GetItemResult getItemResult = this.delegate.getItem(s, map, aBoolean);
            return getItemResult;
        }
    }

    public ListTablesResult listTables(ListTablesRequest listTablesRequest) {
        try (Timer.Context ignored = this.listTablesTimer.time();){
            ListTablesResult listTablesResult = this.delegate.listTables(listTablesRequest);
            return listTablesResult;
        }
    }

    public ListTablesResult listTables() {
        try (Timer.Context ignored = this.listTablesTimer.time();){
            ListTablesResult listTablesResult = this.delegate.listTables();
            return listTablesResult;
        }
    }

    public ListTablesResult listTables(String s) {
        try (Timer.Context ignored = this.listTablesTimer.time();){
            ListTablesResult listTablesResult = this.delegate.listTables(s);
            return listTablesResult;
        }
    }

    public ListTablesResult listTables(String s, Integer integer) {
        try (Timer.Context ignored = this.listTablesTimer.time();){
            ListTablesResult listTablesResult = this.delegate.listTables(s, integer);
            return listTablesResult;
        }
    }

    public ListTablesResult listTables(Integer integer) {
        try (Timer.Context ignored = this.listTablesTimer.time();){
            ListTablesResult listTablesResult = this.delegate.listTables(integer);
            return listTablesResult;
        }
    }

    public PutItemResult putItem(PutItemRequest putItemRequest) {
        try (Timer.Context ignored = this.putItemTimer.time();){
            PutItemResult putItemResult = this.delegate.putItem(putItemRequest);
            return putItemResult;
        }
    }

    public PutItemResult putItem(String s, Map<String, AttributeValue> map) {
        try (Timer.Context ignored = this.putItemTimer.time();){
            PutItemResult putItemResult = this.delegate.putItem(s, map);
            return putItemResult;
        }
    }

    public PutItemResult putItem(String s, Map<String, AttributeValue> map, String s1) {
        try (Timer.Context ignored = this.putItemTimer.time();){
            PutItemResult putItemResult = this.delegate.putItem(s, map, s1);
            return putItemResult;
        }
    }

    public QueryResult query(QueryRequest queryRequest) {
        try (Timer.Context ignored = this.queryTimer.time();){
            QueryResult queryResult = this.delegate.query(queryRequest);
            return queryResult;
        }
    }

    public ScanResult scan(ScanRequest scanRequest) {
        try (Timer.Context ignored = this.scanTimer.time();){
            ScanResult scanResult = this.delegate.scan(scanRequest);
            return scanResult;
        }
    }

    public ScanResult scan(String s, List<String> list) {
        try (Timer.Context ignored = this.scanTimer.time();){
            ScanResult scanResult = this.delegate.scan(s, list);
            return scanResult;
        }
    }

    public ScanResult scan(String s, Map<String, Condition> map) {
        try (Timer.Context ignored = this.scanTimer.time();){
            ScanResult scanResult = this.delegate.scan(s, map);
            return scanResult;
        }
    }

    public ScanResult scan(String s, List<String> list, Map<String, Condition> map) {
        try (Timer.Context ignored = this.scanTimer.time();){
            ScanResult scanResult = this.delegate.scan(s, list, map);
            return scanResult;
        }
    }

    public UpdateItemResult updateItem(UpdateItemRequest updateItemRequest) {
        try (Timer.Context ignored = this.updateItemTimer.time();){
            UpdateItemResult updateItemResult = this.delegate.updateItem(updateItemRequest);
            return updateItemResult;
        }
    }

    public UpdateItemResult updateItem(String s, Map<String, AttributeValue> map, Map<String, AttributeValueUpdate> map1) {
        try (Timer.Context ignored = this.updateItemTimer.time();){
            UpdateItemResult updateItemResult = this.delegate.updateItem(s, map, map1);
            return updateItemResult;
        }
    }

    public UpdateItemResult updateItem(String s, Map<String, AttributeValue> map, Map<String, AttributeValueUpdate> map1, String s1) {
        try (Timer.Context ignored = this.updateItemTimer.time();){
            UpdateItemResult updateItemResult = this.delegate.updateItem(s, map, map1, s1);
            return updateItemResult;
        }
    }

    public UpdateTableResult updateTable(UpdateTableRequest updateTableRequest) {
        try (Timer.Context ignored = this.updateTableTimer.time();){
            UpdateTableResult updateTableResult = this.delegate.updateTable(updateTableRequest);
            return updateTableResult;
        }
    }

    public UpdateTableResult updateTable(String s, ProvisionedThroughput provisionedThroughput) {
        try (Timer.Context ignored = this.updateTableTimer.time();){
            UpdateTableResult updateTableResult = this.delegate.updateTable(s, provisionedThroughput);
            return updateTableResult;
        }
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest amazonWebServiceRequest) {
        return this.delegate.getCachedResponseMetadata(amazonWebServiceRequest);
    }

    public AmazonDynamoDBWaiters waiters() {
        return new AmazonDynamoDBWaiters(this.delegate);
    }
}

