/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.consumer;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.EventDecoder;
import io.codemonastery.dropwizard.kinesis.consumer.BatchConsumer;
import io.codemonastery.dropwizard.kinesis.consumer.BatchProcessor;
import io.codemonastery.dropwizard.kinesis.consumer.BatchProcessorMetrics;
import java.util.function.Supplier;

public class BatchRecordProcessorFactory<E>
implements IRecordProcessorFactory {
    private final EventDecoder<E> decoder;
    private final Supplier<BatchConsumer<E>> eventConsumerFactory;
    private final BatchProcessorMetrics metrics;

    public BatchRecordProcessorFactory(EventDecoder<E> decoder, Supplier<BatchConsumer<E>> eventConsumerFactory, BatchProcessorMetrics metrics) {
        Preconditions.checkNotNull(decoder, (Object)"decoder cannot be null");
        Preconditions.checkNotNull(eventConsumerFactory, (Object)"eventConsumerFactory cannot be null");
        Preconditions.checkNotNull((Object)metrics, (Object)"metrics cannot be null");
        this.decoder = decoder;
        this.eventConsumerFactory = eventConsumerFactory;
        this.metrics = metrics;
    }

    public IRecordProcessor createProcessor() {
        return new BatchProcessor<E>(this.decoder, this.eventConsumerFactory.get(), this.metrics);
    }
}

