/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.CreateStreamResult;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.ResourceInUseException;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.dropwizard.util.Duration;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCreateConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(StreamCreateConfiguration.class);
    @Min(value=1L)
    private int shardCount = 1;
    @Valid
    @NotNull
    private Duration retryPeriod = Duration.seconds((long)5L);
    @Min(value=1L)
    private Integer maxAttempts;

    @JsonProperty
    public int getShardCount() {
        return this.shardCount;
    }

    @JsonProperty
    public void setShardCount(int shardCount) {
        this.shardCount = shardCount;
    }

    @JsonIgnore
    public StreamCreateConfiguration shardCount(int shardCount) {
        this.setShardCount(shardCount);
        return this;
    }

    @JsonProperty
    public Duration getRetryPeriod() {
        return this.retryPeriod;
    }

    @JsonProperty
    public void setRetryPeriod(Duration retryPeriod) {
        this.retryPeriod = retryPeriod;
    }

    @JsonProperty
    public StreamCreateConfiguration retryPeriod(Duration retryPeriod) {
        this.setRetryPeriod(retryPeriod);
        return this;
    }

    @JsonProperty
    public Integer getMaxAttempts() {
        return this.maxAttempts;
    }

    @JsonProperty
    public void setMaxAttempts(Integer maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    @JsonIgnore
    public StreamCreateConfiguration maxAttempts(Integer maxAttempts) {
        this.setMaxAttempts(maxAttempts);
        return this;
    }

    @JsonIgnore
    public boolean setupStream(AmazonKinesis kinesis, String streamName) {
        boolean setup;
        block5: {
            setup = false;
            Preconditions.checkState((!Strings.isNullOrEmpty((String)streamName) ? 1 : 0) != 0, (Object)"streamName was not specified");
            try {
                if (this.getRetryPeriod() == null) break block5;
                Integer retryAttempts = this.getMaxAttempts();
                while (retryAttempts == null || retryAttempts > 0) {
                    block6: {
                        try {
                            DescribeStreamResult result = kinesis.describeStream(streamName);
                            if (!"active".equalsIgnoreCase(result.getStreamDescription().getStreamStatus())) break block6;
                            LOG.info("stream {} is active", (Object)streamName);
                            setup = true;
                            break;
                        }
                        catch (ResourceNotFoundException | NullPointerException e) {
                            this.createStream(kinesis, streamName);
                        }
                    }
                    Thread.sleep(this.retryPeriod.toMilliseconds());
                    if (retryAttempts == null) continue;
                    Integer n = retryAttempts;
                    Integer n2 = retryAttempts = Integer.valueOf(retryAttempts - 1);
                }
            }
            catch (InterruptedException e) {
                LOG.error("Needed to create stream {} but was interrupted, nothing is guaranteed now", (Object)streamName);
            }
        }
        return setup;
    }

    private void createStream(AmazonKinesis kinesis, String streamName) {
        LOG.info(String.format("stream %s was not found, creating with %d shards", streamName, this.getShardCount()));
        try {
            CreateStreamResult stream = kinesis.createStream(streamName, Integer.valueOf(this.getShardCount()));
        }
        catch (ResourceInUseException ue) {
            LOG.info(String.format("failed to create stream %s because it already existed", streamName));
        }
        catch (Exception e) {
            LOG.error(String.format("failed to create stream %s", e), (Throwable)e);
        }
    }
}

