/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemonastery.dropwizard.kinesis.JacksonClientConfiguration;
import io.codemonastery.dropwizard.kinesis.lifecycle.ManagedDynamoDbClient;
import io.codemonastery.dropwizard.kinesis.metric.ClientMetricsProxyFactory;
import io.codemonastery.dropwizard.kinesis.metric.DynamoDbMetricsProxy;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.setup.Environment;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class DynamoDbFactory {
    @NotNull
    private Regions region = Regions.DEFAULT_REGION;
    private ClientMetricsProxyFactory<AmazonDynamoDB> metricsProxyFactory = DynamoDbMetricsProxy::new;
    @Valid
    @NotNull
    private JacksonClientConfiguration client = new JacksonClientConfiguration();

    @JsonProperty
    public Regions getRegion() {
        return this.region;
    }

    @JsonProperty
    public void setRegion(Regions region) {
        this.region = region;
    }

    public DynamoDbFactory region(Regions region) {
        this.setRegion(region);
        return this;
    }

    @JsonIgnore
    public ClientMetricsProxyFactory<AmazonDynamoDB> getMetricsProxyFactory() {
        return this.metricsProxyFactory;
    }

    @JsonIgnore
    public void setMetricsProxyFactory(ClientMetricsProxyFactory<AmazonDynamoDB> metricsProxyFactory) {
        this.metricsProxyFactory = metricsProxyFactory;
    }

    @JsonIgnore
    public DynamoDbFactory metricsProxy(ClientMetricsProxyFactory<AmazonDynamoDB> metricsProxyFactory) {
        this.setMetricsProxyFactory(metricsProxyFactory);
        return this;
    }

    @JsonProperty
    public JacksonClientConfiguration getClient() {
        return this.client;
    }

    @JsonProperty
    public void setClient(JacksonClientConfiguration client) {
        this.client = client;
    }

    @JsonIgnore
    public void setClient(ClientConfiguration client) {
        this.client = new JacksonClientConfiguration(client);
    }

    @JsonIgnore
    public DynamoDbFactory client(ClientConfiguration clientConfiguration) {
        this.setClient(clientConfiguration);
        return this;
    }

    @JsonIgnore
    public DynamoDbFactory client(JacksonClientConfiguration clientConfiguration) {
        this.setClient(clientConfiguration);
        return this;
    }

    @JsonIgnore
    public AmazonDynamoDB build(Environment environment, AWSCredentialsProvider credentialsProvider, String name) {
        return this.build(environment == null ? null : environment.metrics(), environment == null ? null : environment.lifecycle(), credentialsProvider, name);
    }

    @JsonIgnore
    public AmazonDynamoDB build(MetricRegistry metrics, LifecycleEnvironment lifecycle, AWSCredentialsProvider credentialsProvider, String name) {
        AmazonDynamoDBClient client = this.makeClient(credentialsProvider);
        if (metrics != null && this.getMetricsProxyFactory() != null) {
            client = this.getMetricsProxyFactory().proxy((AmazonDynamoDB)client, metrics, name);
        }
        if (lifecycle != null) {
            lifecycle.manage((Managed)new ManagedDynamoDbClient((AmazonDynamoDB)client));
        }
        return client;
    }

    private AmazonDynamoDBClient makeClient(AWSCredentialsProvider credentialsProvider) {
        AmazonDynamoDBClient client = new AmazonDynamoDBClient(credentialsProvider, (ClientConfiguration)this.getClient());
        if (this.getRegion() != null) {
            client.withRegion(this.getRegion());
        }
        return client;
    }
}

