/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.producer;

import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PutRecordsBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(PutRecordsBuffer.class);
    private final ArrayDeque<PutRecordsRequestEntry> queue;
    private final int maxBufferByteSize;
    private int bufferByteSize;
    private int maxBufferRecordSize;

    public PutRecordsBuffer(int maxBufferRecordSize) {
        this(maxBufferRecordSize, 0x500000);
    }

    public PutRecordsBuffer(int maxBufferRecordSize, int maxBufferByteSize) {
        this.maxBufferByteSize = maxBufferByteSize;
        this.maxBufferRecordSize = maxBufferRecordSize;
        this.queue = new ArrayDeque(this.maxBufferRecordSize);
    }

    public synchronized List<List<PutRecordsRequestEntry>> addAll(List<PutRecordsRequestEntry> es) {
        ArrayList<List<PutRecordsRequestEntry>> submitMes = new ArrayList<List<PutRecordsRequestEntry>>();
        for (PutRecordsRequestEntry e : es) {
            List<PutRecordsRequestEntry> submitMe = this.add(e);
            if (submitMe == null) continue;
            submitMes.add(submitMe);
        }
        return submitMes;
    }

    public synchronized List<PutRecordsRequestEntry> add(PutRecordsRequestEntry e) {
        ArrayList<PutRecordsRequestEntry> submitMe = null;
        if (e.getData().limit() > this.maxBufferByteSize) {
            LOG.error("Encountered extreme degenerate case, record was too large to fit in buffer, should have never encountered this!");
        } else {
            if (this.bufferByteSize + e.getData().limit() > this.maxBufferByteSize || this.queue.size() == this.maxBufferRecordSize) {
                submitMe = new ArrayList<PutRecordsRequestEntry>(this.queue);
                this.queue.clear();
                this.bufferByteSize = 0;
            }
            this.queue.add(e);
            this.bufferByteSize += e.getData().limit();
        }
        return submitMe;
    }

    public synchronized List<PutRecordsRequestEntry> drain() {
        ArrayList<PutRecordsRequestEntry> submitMe = new ArrayList<PutRecordsRequestEntry>(this.queue);
        this.queue.clear();
        this.bufferByteSize = 0;
        return submitMe;
    }
}

