/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.consumer;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.codemonastery.dropwizard.kinesis.metric.HasFailureThresholds;
import io.codemonastery.dropwizard.kinesis.producer.NoOpClose;
import java.util.ArrayList;
import java.util.List;

public class RecordProcessorMetrics
implements HasFailureThresholds {
    private Counter processorCounter;
    private Meter decodeSuccessMeter;
    private Meter decodeFailureMeter;
    private Meter successMeter;
    private Meter failureMeter;
    private Timer processTimer;
    private Timer checkpointTimer;
    private Meter checkpointFailure;
    private Meter unhandledExceptionMeter;
    private static final double failureFrequencyThreshold = 0.1;

    public static RecordProcessorMetrics noOp() {
        return new RecordProcessorMetrics(null, "");
    }

    public RecordProcessorMetrics(MetricRegistry metrics, String name) {
        if (metrics != null) {
            this.processorCounter = metrics.counter(name + "-processors");
            this.decodeSuccessMeter = metrics.meter(name + "-decode-success");
            this.decodeFailureMeter = metrics.meter(name + "-decode-failure");
            this.successMeter = metrics.meter(name + "-success");
            this.failureMeter = metrics.meter(name + "-failure");
            this.processTimer = metrics.timer(name + "-process");
            this.checkpointTimer = metrics.timer(name + "-checkpoint");
            this.checkpointFailure = metrics.meter(name + "-checkpoint-failure");
            this.unhandledExceptionMeter = metrics.meter(name + "-unhandled-exception");
        }
    }

    public void processorStarted() {
        if (this.processorCounter != null) {
            this.processorCounter.inc();
        }
    }

    public void processorShutdown() {
        if (this.processorCounter != null) {
            this.processorCounter.dec();
        }
    }

    public void decoded() {
        if (this.decodeSuccessMeter != null) {
            this.decodeSuccessMeter.mark();
            this.unhandledExceptionMeter.mark();
        }
    }

    public void decodeFailure() {
        if (this.decodeFailureMeter != null) {
            this.decodeFailureMeter.mark();
            this.unhandledExceptionMeter.mark();
        }
    }

    public void processSuccess() {
        if (this.successMeter != null) {
            this.successMeter.mark();
        }
    }

    public void processFailure() {
        if (this.failureMeter != null) {
            this.failureMeter.mark();
        }
    }

    public void unhandledException() {
        if (this.unhandledExceptionMeter != null) {
            this.unhandledExceptionMeter.mark();
        }
    }

    public AutoCloseable processTime() {
        return this.processTimer == null ? NoOpClose.INSTANCE : this.processTimer.time();
    }

    public AutoCloseable checkpointTime() {
        return this.checkpointTimer == null ? NoOpClose.INSTANCE : this.checkpointTimer.time();
    }

    public void checkpointFailed() {
        this.checkpointFailure.mark();
    }

    @Override
    public List<String> highFailureMetrics() {
        double checkpointFailureFrequency;
        double processFailureFrequency;
        ArrayList<String> failed = new ArrayList<String>();
        double encodeFailureFrequency = this.frequency((Metered)this.decodeSuccessMeter, (Metered)this.decodeFailureMeter);
        if (0.1 <= encodeFailureFrequency) {
            failed.add(String.format("%.2f%% decode failure", encodeFailureFrequency * 100.0));
        }
        if (0.1 <= (processFailureFrequency = this.frequency((Metered)this.successMeter, (Metered)this.failureMeter))) {
            failed.add(String.format("%.2f%% process failure", processFailureFrequency * 100.0));
        }
        if (0.1 <= (checkpointFailureFrequency = this.checkpointFailure.getOneMinuteRate() / this.checkpointTimer.getOneMinuteRate())) {
            failed.add(String.format("%.2f%% checkpoint failure", checkpointFailureFrequency * 100.0));
        }
        return failed;
    }

    private double frequency(Metered successMeter, Metered failureMeter) {
        Double successRate = successMeter.getOneMinuteRate();
        Double failureRate = failureMeter.getOneMinuteRate();
        double totalRate = successRate + failureRate;
        return failureRate / totalRate;
    }
}

