/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.producer;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.EventEncoder;
import io.codemonastery.dropwizard.kinesis.producer.Producer;
import io.codemonastery.dropwizard.kinesis.producer.ProducerMetrics;
import java.io.Closeable;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleProducer<E>
extends Producer<E> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleProducer.class);
    private final AmazonKinesis kinesis;
    private final String streamName;

    public SimpleProducer(AmazonKinesis kinesis, String streamName, Function<E, String> partitionKeyFn, EventEncoder<E> encoder, ProducerMetrics metrics) {
        super(partitionKeyFn, encoder, metrics);
        Preconditions.checkNotNull((Object)kinesis, (Object)"client cannot be null");
        Preconditions.checkNotNull((Object)streamName, (Object)"streamName cannot be null");
        this.kinesis = kinesis;
        this.streamName = streamName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void send(PutRecordsRequestEntry record) throws Exception {
        int failedCount = 1;
        try (Closeable ignored = this.metrics.time();){
            PutRecordsResult result = this.kinesis.putRecords(new PutRecordsRequest().withRecords(new PutRecordsRequestEntry[]{record}).withStreamName(this.streamName));
            failedCount = Optional.ofNullable(result.getFailedRecordCount()).orElse(0);
            if (LOG.isDebugEnabled()) {
                String message = String.format("Put %d records to stream %s, %d failed", result.getRecords().size(), this.streamName, failedCount);
                LOG.debug(message);
            }
        }
        finally {
            this.metrics.sent(1 - failedCount, failedCount);
        }
    }
}

