/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.producer;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.codemonastery.dropwizard.kinesis.EventEncoder;
import io.codemonastery.dropwizard.kinesis.EventObjectMapper;
import io.codemonastery.dropwizard.kinesis.StreamConfiguration;
import io.codemonastery.dropwizard.kinesis.producer.Producer;
import io.codemonastery.dropwizard.kinesis.producer.ProducerFactory;
import io.dropwizard.setup.Environment;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractProducerFactory<E>
extends StreamConfiguration
implements ProducerFactory<E> {
    protected Function<E, String> partitionKeyFn = Objects::toString;
    protected EventEncoder<E> encoder;

    @Override
    @JsonIgnore
    public ProducerFactory<E> streamName(String streamName) {
        super.setStreamName(streamName);
        return this;
    }

    @Override
    @JsonIgnore
    public Function<E, String> getPartitionKeyFn() {
        return this.partitionKeyFn;
    }

    @Override
    @JsonIgnore
    public void setPartitionKeyFn(Function<E, String> partitionKeyFn) {
        this.partitionKeyFn = partitionKeyFn;
    }

    @Override
    @JsonIgnore
    public ProducerFactory<E> partitionKeyFn(Function<E, String> partitionKeyFn) {
        this.setPartitionKeyFn(partitionKeyFn);
        return this;
    }

    @Override
    @JsonIgnore
    public EventEncoder<E> getEncoder() {
        return this.encoder;
    }

    @Override
    @JsonIgnore
    public void setEncoder(EventEncoder<E> encoder) {
        this.encoder = encoder;
    }

    @Override
    @JsonIgnore
    public ProducerFactory<E> encoder(EventEncoder<E> encoder) {
        this.setEncoder(encoder);
        return this;
    }

    @Override
    @JsonIgnore
    public Producer<E> build(Environment environment, AmazonKinesis kinesis, String name) {
        if (this.encoder == null && environment != null) {
            this.encoder = new EventObjectMapper(environment.getObjectMapper(), null);
        }
        return this.build(environment == null ? null : environment.metrics(), environment == null ? null : environment.healthChecks(), environment == null ? null : environment.lifecycle(), kinesis, name);
    }
}

