/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.metric;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.regions.Region;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.AddTagsToStreamRequest;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import com.amazonaws.services.kinesis.model.DeleteStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import com.amazonaws.services.kinesis.model.ListStreamsRequest;
import com.amazonaws.services.kinesis.model.ListStreamsResult;
import com.amazonaws.services.kinesis.model.ListTagsForStreamRequest;
import com.amazonaws.services.kinesis.model.ListTagsForStreamResult;
import com.amazonaws.services.kinesis.model.MergeShardsRequest;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.amazonaws.services.kinesis.model.RemoveTagsFromStreamRequest;
import com.amazonaws.services.kinesis.model.SplitShardRequest;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;

public class KinesisMetricsProxy
implements AmazonKinesis {
    private final AmazonKinesis delegate;
    private final Timer addTagsToStreamTimer;
    private final Timer createStreamTimer;
    private final Timer decreaseStreamRetentionPeriodTimer;
    private final Timer getRecordsTimer;
    private final Timer getShardIteratorTimer;
    private final Timer increaseStreamRetentionPeriodTimer;
    private final Timer listStreamsTimer;
    private final Timer listTagsForStreamTimer;
    private final Timer mergeShardsTimer;
    private final Timer putRecordTimer;
    private final Timer putRecordsTimer;
    private final Timer removeTagsFromStreamTimer;
    private final Timer splitShardTimer;
    private final Timer deleteStreamTimer;
    private final Timer describeStreamTimer;

    public KinesisMetricsProxy(AmazonKinesis delegate, MetricRegistry metrics, String name) {
        Preconditions.checkNotNull((Object)delegate, (Object)"delegate cannot be null");
        this.delegate = delegate;
        this.addTagsToStreamTimer = metrics.timer(name + "-add-tags-to-stream");
        this.createStreamTimer = metrics.timer(name + "-create-stream");
        this.decreaseStreamRetentionPeriodTimer = metrics.timer(name + "-decrease-stream-retention-period");
        this.deleteStreamTimer = metrics.timer(name + "-delete-stream");
        this.describeStreamTimer = metrics.timer(name + "-describe-stream");
        this.getRecordsTimer = metrics.timer(name + "-get-records");
        this.getShardIteratorTimer = metrics.timer(name + "-get-shard-iterator");
        this.increaseStreamRetentionPeriodTimer = metrics.timer(name + "-increase-stream-retention-period");
        this.listStreamsTimer = metrics.timer(name + "-list-streams");
        this.listTagsForStreamTimer = metrics.timer(name + "-list-tags-for-stream");
        this.mergeShardsTimer = metrics.timer(name + "-merge-shards");
        this.putRecordTimer = metrics.timer(name + "-put-record");
        this.putRecordsTimer = metrics.timer(name + "-put-records");
        this.removeTagsFromStreamTimer = metrics.timer(name + "-remove-tags-from-stream");
        this.splitShardTimer = metrics.timer(name + "-split-shard");
    }

    public void setEndpoint(String endpoint) {
        this.delegate.setEndpoint(endpoint);
    }

    public void setRegion(Region region) {
        this.delegate.setRegion(region);
    }

    public void addTagsToStream(AddTagsToStreamRequest addTagsToStreamRequest) {
        try (Timer.Context time = this.addTagsToStreamTimer.time();){
            this.delegate.addTagsToStream(addTagsToStreamRequest);
        }
    }

    public void createStream(CreateStreamRequest createStreamRequest) {
        try (Timer.Context time = this.createStreamTimer.time();){
            this.delegate.createStream(createStreamRequest);
        }
    }

    public void createStream(String streamName, Integer shardCount) {
        try (Timer.Context time = this.createStreamTimer.time();){
            this.delegate.createStream(streamName, shardCount);
        }
    }

    public void decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest decreaseStreamRetentionPeriodRequest) {
        try (Timer.Context time = this.decreaseStreamRetentionPeriodTimer.time();){
            this.delegate.decreaseStreamRetentionPeriod(decreaseStreamRetentionPeriodRequest);
        }
    }

    public void deleteStream(DeleteStreamRequest deleteStreamRequest) {
        try (Timer.Context time = this.deleteStreamTimer.time();){
            this.delegate.deleteStream(deleteStreamRequest);
        }
    }

    public void deleteStream(String streamName) {
        try (Timer.Context time = this.deleteStreamTimer.time();){
            this.delegate.deleteStream(streamName);
        }
    }

    public DescribeStreamResult describeStream(DescribeStreamRequest describeStreamRequest) {
        try (Timer.Context time = this.describeStreamTimer.time();){
            DescribeStreamResult describeStreamResult = this.delegate.describeStream(describeStreamRequest);
            return describeStreamResult;
        }
    }

    public DescribeStreamResult describeStream(String streamName) {
        try (Timer.Context time = this.describeStreamTimer.time();){
            DescribeStreamResult describeStreamResult = this.delegate.describeStream(streamName);
            return describeStreamResult;
        }
    }

    public DescribeStreamResult describeStream(String streamName, String exclusiveStartShardId) {
        try (Timer.Context time = this.describeStreamTimer.time();){
            DescribeStreamResult describeStreamResult = this.delegate.describeStream(streamName, exclusiveStartShardId);
            return describeStreamResult;
        }
    }

    public DescribeStreamResult describeStream(String streamName, Integer limit, String exclusiveStartShardId) {
        try (Timer.Context time = this.describeStreamTimer.time();){
            DescribeStreamResult describeStreamResult = this.delegate.describeStream(streamName, limit, exclusiveStartShardId);
            return describeStreamResult;
        }
    }

    public GetRecordsResult getRecords(GetRecordsRequest getRecordsRequest) {
        try (Timer.Context time = this.getRecordsTimer.time();){
            GetRecordsResult getRecordsResult = this.delegate.getRecords(getRecordsRequest);
            return getRecordsResult;
        }
    }

    public GetShardIteratorResult getShardIterator(GetShardIteratorRequest getShardIteratorRequest) {
        try (Timer.Context time = this.getShardIteratorTimer.time();){
            GetShardIteratorResult getShardIteratorResult = this.delegate.getShardIterator(getShardIteratorRequest);
            return getShardIteratorResult;
        }
    }

    public GetShardIteratorResult getShardIterator(String streamName, String shardId, String shardIteratorType) {
        try (Timer.Context time = this.getShardIteratorTimer.time();){
            GetShardIteratorResult getShardIteratorResult = this.delegate.getShardIterator(streamName, shardId, shardIteratorType);
            return getShardIteratorResult;
        }
    }

    public GetShardIteratorResult getShardIterator(String streamName, String shardId, String shardIteratorType, String startingSequenceNumber) {
        try (Timer.Context time = this.getShardIteratorTimer.time();){
            GetShardIteratorResult getShardIteratorResult = this.delegate.getShardIterator(streamName, shardId, shardIteratorType, startingSequenceNumber);
            return getShardIteratorResult;
        }
    }

    public void increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest increaseStreamRetentionPeriodRequest) {
        try (Timer.Context time = this.increaseStreamRetentionPeriodTimer.time();){
            this.delegate.increaseStreamRetentionPeriod(increaseStreamRetentionPeriodRequest);
        }
    }

    public ListStreamsResult listStreams(ListStreamsRequest listStreamsRequest) {
        try (Timer.Context time = this.listStreamsTimer.time();){
            ListStreamsResult listStreamsResult = this.delegate.listStreams(listStreamsRequest);
            return listStreamsResult;
        }
    }

    public ListStreamsResult listStreams() {
        try (Timer.Context time = this.listStreamsTimer.time();){
            ListStreamsResult listStreamsResult = this.delegate.listStreams();
            return listStreamsResult;
        }
    }

    public ListStreamsResult listStreams(String exclusiveStartStreamName) {
        try (Timer.Context time = this.listStreamsTimer.time();){
            ListStreamsResult listStreamsResult = this.delegate.listStreams(exclusiveStartStreamName);
            return listStreamsResult;
        }
    }

    public ListStreamsResult listStreams(Integer limit, String exclusiveStartStreamName) {
        try (Timer.Context time = this.listStreamsTimer.time();){
            ListStreamsResult listStreamsResult = this.delegate.listStreams(limit, exclusiveStartStreamName);
            return listStreamsResult;
        }
    }

    public ListTagsForStreamResult listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) {
        try (Timer.Context time = this.listTagsForStreamTimer.time();){
            ListTagsForStreamResult listTagsForStreamResult = this.delegate.listTagsForStream(listTagsForStreamRequest);
            return listTagsForStreamResult;
        }
    }

    public void mergeShards(MergeShardsRequest mergeShardsRequest) {
        try (Timer.Context time = this.mergeShardsTimer.time();){
            this.delegate.mergeShards(mergeShardsRequest);
        }
    }

    public void mergeShards(String streamName, String shardToMerge, String adjacentShardToMerge) {
        try (Timer.Context time = this.mergeShardsTimer.time();){
            this.delegate.mergeShards(streamName, shardToMerge, adjacentShardToMerge);
        }
    }

    public PutRecordResult putRecord(PutRecordRequest putRecordRequest) {
        try (Timer.Context timer = this.putRecordTimer.time();){
            PutRecordResult putRecordResult = this.delegate.putRecord(putRecordRequest);
            return putRecordResult;
        }
    }

    public PutRecordResult putRecord(String streamName, ByteBuffer data, String partitionKey) {
        try (Timer.Context timer = this.putRecordTimer.time();){
            PutRecordResult putRecordResult = this.delegate.putRecord(streamName, data, partitionKey);
            return putRecordResult;
        }
    }

    public PutRecordResult putRecord(String streamName, ByteBuffer data, String partitionKey, String sequenceNumberForOrdering) {
        try (Timer.Context timer = this.putRecordTimer.time();){
            PutRecordResult putRecordResult = this.delegate.putRecord(streamName, data, partitionKey, sequenceNumberForOrdering);
            return putRecordResult;
        }
    }

    public PutRecordsResult putRecords(PutRecordsRequest putRecordsRequest) {
        try (Timer.Context timer = this.putRecordsTimer.time();){
            PutRecordsResult putRecordsResult = this.delegate.putRecords(putRecordsRequest);
            return putRecordsResult;
        }
    }

    public void removeTagsFromStream(RemoveTagsFromStreamRequest removeTagsFromStreamRequest) {
        try (Timer.Context time = this.removeTagsFromStreamTimer.time();){
            this.delegate.removeTagsFromStream(removeTagsFromStreamRequest);
        }
    }

    public void splitShard(SplitShardRequest splitShardRequest) {
        try (Timer.Context time = this.splitShardTimer.time();){
            this.delegate.splitShard(splitShardRequest);
        }
    }

    public void splitShard(String streamName, String shardToSplit, String newStartingHashKey) {
        try (Timer.Context time = this.splitShardTimer.time();){
            this.delegate.splitShard(streamName, shardToSplit, newStartingHashKey);
        }
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.delegate.getCachedResponseMetadata(request);
    }
}

