/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis.consumer;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.SimpleWorker;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.EventDecoder;
import io.codemonastery.dropwizard.kinesis.EventObjectMapper;
import io.codemonastery.dropwizard.kinesis.consumer.EventConsumer;
import io.codemonastery.dropwizard.kinesis.consumer.KinesisClientLibConfig;
import io.codemonastery.dropwizard.kinesis.consumer.RecordProcessorFactory;
import io.codemonastery.dropwizard.kinesis.consumer.RecordProcessorMetrics;
import io.codemonastery.dropwizard.kinesis.healthcheck.StreamHealthCheck;
import io.codemonastery.dropwizard.kinesis.producer.StreamFailureCheck;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.setup.Environment;
import java.lang.reflect.ParameterizedType;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerFactory<E>
extends KinesisClientLibConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerFactory.class);
    private ConsumerFactory<E> decoderInheritParent = null;
    private EventDecoder<E> decoder;
    private Supplier<EventConsumer<E>> consumer;

    @JsonIgnore
    public ConsumerFactory<E> streamName(String streamName) {
        this.setStreamName(streamName);
        return this;
    }

    @JsonIgnore
    public EventDecoder<E> getDecoder() {
        return this.decoder;
    }

    @JsonIgnore
    public void setDecoder(EventDecoder<E> decoder) {
        this.decoder = decoder;
    }

    @JsonIgnore
    public ConsumerFactory<E> decoder(EventDecoder<E> decoder) {
        this.setDecoder(decoder);
        return this;
    }

    @JsonIgnore
    public Supplier<EventConsumer<E>> getConsumer() {
        return this.consumer;
    }

    @JsonIgnore
    public void setConsumer(Supplier<EventConsumer<E>> consumer) {
        this.consumer = consumer;
    }

    @JsonIgnore
    public ConsumerFactory<E> consumer(Supplier<EventConsumer<E>> consumer) {
        this.setConsumer(consumer);
        return this;
    }

    @JsonIgnore
    public ConsumerFactory<E> inheritDecoder(ConsumerFactory<E> other) {
        this.decoderInheritParent = other;
        return this;
    }

    @JsonIgnore
    public SimpleWorker build(Environment environment, AmazonKinesis kinesis, AmazonDynamoDB dynamoDb, String name) {
        if (environment != null && this.decoder == null) {
            this.decoder = this.inferDecoder(environment.getObjectMapper());
        }
        if (this.consumer == null) {
            this.consumer = () -> event -> {
                if (event != null) {
                    LOG.info("Consumed event on " + name + ": " + event.toString());
                }
                return true;
            };
        }
        return this.build(environment == null ? null : environment.metrics(), environment == null ? null : environment.healthChecks(), environment == null ? null : environment.lifecycle(), kinesis, dynamoDb, name);
    }

    @JsonIgnore
    public SimpleWorker build(MetricRegistry metrics, HealthCheckRegistry healthChecks, LifecycleEnvironment lifeCycle, AmazonKinesis kinesis, AmazonDynamoDB dynamoDb, String name) {
        Preconditions.checkNotNull(this.decoder, (Object)"decoder cannot be null");
        Preconditions.checkNotNull(this.consumer, (Object)"consumer cannot be null");
        super.setupStream(kinesis);
        RecordProcessorMetrics processorMetrics = new RecordProcessorMetrics(metrics, name);
        RecordProcessorFactory<E> recordProcessorFactory = new RecordProcessorFactory<E>(this.decoder, this.consumer, processorMetrics);
        SimpleWorker.Builder builder = new SimpleWorker.Builder().recordProcessorFactory(recordProcessorFactory).config(this.makeKinesisClientLibConfiguration(name)).kinesisClient(kinesis).dynamoDBClient(dynamoDb);
        if (healthChecks != null) {
            healthChecks.register(name, (HealthCheck)new StreamFailureCheck(processorMetrics, new StreamHealthCheck(kinesis, this.getStreamName())));
        }
        if (lifeCycle != null) {
            ExecutorService processorService = lifeCycle.executorService(name + "-processor-%d").build();
            builder.execService(processorService).build();
        }
        SimpleWorker worker = builder.build();
        if (lifeCycle != null) {
            lifeCycle.executorService(name + "-consumer-worker").minThreads(1).maxThreads(1).build().submit(worker::run);
        }
        return worker;
    }

    EventObjectMapper<E> inferDecoder(ObjectMapper objectMapper) {
        EventObjectMapper decoder = null;
        Class eventClass = null;
        try {
            eventClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            LOG.error("Tried to infer event class to make default decoder, but failed", (Throwable)e);
        }
        if (eventClass != null) {
            decoder = new EventObjectMapper(objectMapper, eventClass);
        } else if (this.decoderInheritParent != null) {
            decoder = this.decoderInheritParent.inferDecoder(objectMapper);
        }
        return decoder;
    }
}

