/*
 * Decompiled with CFR 0.152.
 */
package io.codemonastery.dropwizard.kinesis;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.codemonastery.dropwizard.kinesis.JacksonClientConfiguration;
import io.codemonastery.dropwizard.kinesis.healthcheck.KinesisClientHealthCheck;
import io.codemonastery.dropwizard.kinesis.lifecycle.ManagedKinesisClient;
import io.codemonastery.dropwizard.kinesis.metric.ClientMetricsProxyFactory;
import io.codemonastery.dropwizard.kinesis.metric.KinesisMetricsProxy;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.setup.Environment;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class KinesisFactory {
    @NotNull
    private Regions region = Regions.DEFAULT_REGION;
    private ClientMetricsProxyFactory<AmazonKinesis> metricsProxy = KinesisMetricsProxy::new;
    @NotNull
    private JacksonClientConfiguration client = new JacksonClientConfiguration();

    @JsonProperty
    public Regions getRegion() {
        return this.region;
    }

    @JsonProperty
    public void setRegion(Regions region) {
        this.region = region;
    }

    @JsonIgnore
    public KinesisFactory region(Regions region) {
        this.setRegion(region);
        return this;
    }

    @JsonIgnore
    public ClientMetricsProxyFactory<AmazonKinesis> getMetricsProxy() {
        return this.metricsProxy;
    }

    @JsonIgnore
    public void setMetricsProxy(ClientMetricsProxyFactory<AmazonKinesis> metricsProxy) {
        this.metricsProxy = metricsProxy;
    }

    @JsonIgnore
    public KinesisFactory metricsProxy(ClientMetricsProxyFactory<AmazonKinesis> metricsProxy) {
        this.setMetricsProxy(metricsProxy);
        return this;
    }

    @JsonProperty
    public JacksonClientConfiguration getClient() {
        return this.client;
    }

    @JsonProperty
    public void setClient(JacksonClientConfiguration client) {
        this.client = client;
    }

    @JsonIgnore
    public void setClient(ClientConfiguration clientConfiguration) {
        this.client = new JacksonClientConfiguration(clientConfiguration);
    }

    @JsonIgnore
    public KinesisFactory client(JacksonClientConfiguration clientConfiguration) {
        this.setClient(clientConfiguration);
        return this;
    }

    @JsonIgnore
    public KinesisFactory client(ClientConfiguration clientConfiguration) {
        this.setClient(new JacksonClientConfiguration(clientConfiguration));
        return this;
    }

    public AmazonKinesis build(@Nullable Environment environment, AWSCredentialsProvider credentialsProvider, String name) {
        return this.build(environment == null ? null : environment.metrics(), environment == null ? null : environment.healthChecks(), environment == null ? null : environment.lifecycle(), credentialsProvider, name);
    }

    public AmazonKinesis build(@Nullable MetricRegistry metrics, @Nullable HealthCheckRegistry healthChecks, @Nullable LifecycleEnvironment lifecycle, AWSCredentialsProvider credentialsProvider, String name) {
        AmazonKinesis client = this.makeClient(credentialsProvider);
        if (metrics != null && this.metricsProxy != null) {
            client = this.metricsProxy.proxy(client, metrics, name);
            Preconditions.checkNotNull((Object)client, (Object)(this.metricsProxy.getClass().getName() + " returned a null client"));
        }
        if (lifecycle != null) {
            lifecycle.manage((Managed)new ManagedKinesisClient(client));
        }
        if (healthChecks != null) {
            healthChecks.register(name, (HealthCheck)new KinesisClientHealthCheck(client));
        }
        return client;
    }

    private AmazonKinesis makeClient(AWSCredentialsProvider credentialsProvider) {
        AmazonKinesisClient client = new AmazonKinesisClient(credentialsProvider, (ClientConfiguration)this.getClient());
        if (this.getRegion() != null) {
            client.withRegion(this.getRegion());
        }
        return client;
    }
}

