/*
 * Decompiled with CFR 0.152.
 */
package io.codegen.jsobuilder.processor;

import io.codegen.jsobuilder.processor.ClassNames;
import io.codegen.jsobuilder.processor.internal.$javapoet$.$ClassName;
import io.codegen.jsobuilder.processor.internal.$javapoet$.$CodeBlock;
import io.codegen.jsobuilder.processor.internal.$javapoet$.$MethodSpec;
import io.codegen.jsobuilder.processor.internal.$javapoet$.$ParameterizedTypeName;
import io.codegen.jsobuilder.processor.internal.$javapoet$.$TypeSpec;
import io.codegen.jsobuilder.processor.internal.$javapoet$.$WildcardTypeName;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class SerializerGenerator {
    public $TypeSpec createSerializer($ClassName className) {
        return $TypeSpec.classBuilder(className).addModifiers(Modifier.STATIC).superclass(className.peerClass("Serializer")).addMethod(this.createToJSONMethod()).addMethod(this.createIsJsObject()).addMethod(this.createWriteJSONMethod()).addMethod(this.createWriteValueMethod()).build();
    }

    private $MethodSpec createToJSONMethod() {
        return $MethodSpec.methodBuilder("toJSON").addModifiers(Modifier.FINAL).addAnnotation(ClassNames.GWT_INCOMPATIBLE).addParameter((Type)((Object)Object.class), "object", new Modifier[0]).returns((Type)((Object)String.class)).beginControlFlow("if (!isJsObject(object.getClass()))", new Object[0]).addStatement("throw new $T($S + object.getClass() + $S)", IllegalStateException.class, "Class ", " isn't a JavaScript object").endControlFlow().addStatement("$T writer = new $T()", StringWriter.class, StringWriter.class).beginControlFlow("try", new Object[0]).addStatement("writeJSON(writer, object)", new Object[0]).nextControlFlow("catch ($T e)", IOException.class).addStatement("throw new $T(e)", RuntimeException.class).endControlFlow().addStatement("return writer.toString()", new Object[0]).build();
    }

    private $MethodSpec createIsJsObject() {
        $CodeBlock.Builder builder = $CodeBlock.builder();
        builder.addStatement("$1T jsType = type.getAnnotation($1T.class)", ClassNames.JSINTEROP_JSTYPE);
        Stream.of("jsType == null", "!jsType.isNative()", "!JsPackage.GLOBAL.equals(jsType.namespace())", "!\"Object\".equals(jsType.name())").forEachOrdered(statement -> builder.beginControlFlow("if (" + statement + ")", new Object[0]).addStatement("return false", new Object[0]).endControlFlow());
        builder.addStatement("return true", new Object[0]);
        return $MethodSpec.methodBuilder("isJsObject").addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addAnnotation(ClassNames.GWT_INCOMPATIBLE).addParameter($ParameterizedTypeName.get($ClassName.get(Class.class), $WildcardTypeName.subtypeOf(Object.class)), "type", new Modifier[0]).returns(Boolean.TYPE).addCode(builder.build()).build();
    }

    private $MethodSpec createWriteJSONMethod() {
        return $MethodSpec.methodBuilder("writeJSON").addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addAnnotation(ClassNames.GWT_INCOMPATIBLE).addParameter((Type)((Object)Writer.class), "writer", new Modifier[0]).addParameter((Type)((Object)Object.class), "value", new Modifier[0]).addException((Type)((Object)IOException.class)).beginControlFlow("if (value == null)", new Object[0]).addStatement("writer.append($S)", "null").addStatement("return", new Object[0]).endControlFlow().addStatement("$T type = value.getClass()", $ParameterizedTypeName.get($ClassName.get(Class.class), $WildcardTypeName.subtypeOf(Object.class))).beginControlFlow("if (type.isPrimitive())", new Object[0]).addStatement("writer.append(String.valueOf(value))", new Object[0]).nextControlFlow("else if (type.isArray())", new Object[0]).addStatement("writer.append('[')", new Object[0]).addStatement("int arraySize = $T.getLength(value)", Array.class).beginControlFlow("for (int arrayIndex = 0; arrayIndex < arraySize; arrayIndex++)", new Object[0]).addStatement("writeJSON(writer, $T.get(value, arrayIndex))", Array.class).beginControlFlow("if (arrayIndex < (arraySize - 1))", new Object[0]).addStatement("writer.append(',')", new Object[0]).endControlFlow().endControlFlow().addStatement("writer.append(']')", new Object[0]).nextControlFlow("else if ($T.class.isAssignableFrom(type))", Number.class).addStatement("writer.append($T.valueOf(value))", String.class).nextControlFlow("else if ($T.class.isAssignableFrom(type))", Boolean.class).addStatement("writer.append($T.valueOf(value))", String.class).nextControlFlow("else if ($T.class.isAssignableFrom(type))", CharSequence.class).addStatement("writer.append('\"')", new Object[0]).addStatement("writeValue(writer, $T.valueOf(value))", String.class).addStatement("writer.append('\"')", new Object[0]).nextControlFlow("else if (isJsObject(type))", new Object[0]).addStatement("writer.append('{')", new Object[0]).addStatement("$T[] fields = type.getDeclaredFields()", Field.class).addStatement("$T<String, Field> fieldByName = new $T<>()", SortedMap.class, TreeMap.class).beginControlFlow("for (int fieldIndex = 0; fieldIndex < fields.length; fieldIndex++)", new Object[0]).addStatement("$T field = fields[fieldIndex]", Field.class).beginControlFlow("if (field.getAnnotation($T.class) != null)", ClassNames.JSINTEROP_JSIGNORE).addStatement("continue", new Object[0]).endControlFlow().beginControlFlow("if (field.getAnnotation($T.class) != null)", ClassNames.JSINTEROP_JSOVERLAY).addStatement("continue", new Object[0]).endControlFlow().addStatement("$T name", String.class).addStatement("$1T property = field.getAnnotation($1T.class)", ClassNames.JSINTEROP_JSPROPERTY).beginControlFlow("if (property != null && !$S.equals(property.name()))", "<auto>").addStatement("name = property.name()", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("name = field.getName()", new Object[0]).endControlFlow().addStatement("fieldByName.put(name, field)", new Object[0]).endControlFlow().addStatement("boolean firstProperty = true", new Object[0]).beginControlFlow("for ($T<$T, $T> entry : fieldByName.entrySet())", Map.Entry.class, String.class, Field.class).beginControlFlow("if (!firstProperty)", new Object[0]).addStatement("writer.append(',')", new Object[0]).endControlFlow().addStatement("writer.append('\"')", new Object[0]).addStatement("writeValue(writer, entry.getKey())", new Object[0]).addStatement("writer.append('\"')", new Object[0]).addStatement("writer.append(':')", new Object[0]).beginControlFlow("try", new Object[0]).addStatement("writeJSON(writer, entry.getValue().get(value))", new Object[0]).nextControlFlow("catch ($T | $T e)", IllegalArgumentException.class, IllegalAccessException.class).addStatement("throw new $T(e)", RuntimeException.class).endControlFlow().addStatement("firstProperty = false", new Object[0]).endControlFlow().addStatement("writer.append('}')", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("throw new $T($S + type)", IllegalArgumentException.class, "Unknown type ").endControlFlow().build();
    }

    private $MethodSpec createWriteValueMethod() {
        $CodeBlock.Builder builder = $CodeBlock.builder();
        builder.beginControlFlow("for (int index = 0; index < value.length(); index++)", new Object[0]).addStatement("char currentCharacter = value.charAt(index)", new Object[0]).beginControlFlow("switch (currentCharacter)", new Object[0]);
        IntStream.of(92, 34, 98, 116, 110, 102, 114).forEach(character -> builder.unindent().add("case '\\$L':\n", Character.toString((char)character)).indent().addStatement("writer.write($S)", "\\" + Character.toString((char)character)).addStatement("break", new Object[0]));
        builder.unindent().add("default:\n", new Object[0]).indent();
        builder.add("if (", new Object[0]);
        builder.add(Stream.of(CharacterRange.of('\u0000', '\u001f'), CharacterRange.of('\u007f', '\u009f'), CharacterRange.of('\u2028', '\u2029')).map(rec$ -> ((CharacterRange)rec$).asCondition()).collect(Collectors.joining("\n || ")), new Object[0]);
        builder.add(") {\n", new Object[0]).indent();
        builder.addStatement("writer.write($S)", "\\u").addStatement("$T hexValue = $T.toHexString(currentCharacter)", String.class, Integer.class).addStatement("writer.write($S, 0, 4 - hexValue.length())", "0000").addStatement("writer.write(hexValue)", new Object[0]);
        builder.unindent().add("} else {\n", new Object[0]).indent();
        builder.addStatement("writer.write(currentCharacter)", new Object[0]);
        builder.unindent().add("}\n", new Object[0]);
        builder.endControlFlow();
        builder.endControlFlow();
        return $MethodSpec.methodBuilder("writeValue").addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addAnnotation(ClassNames.GWT_INCOMPATIBLE).addParameter((Type)((Object)Writer.class), "writer", new Modifier[0]).addParameter((Type)((Object)CharSequence.class), "value", new Modifier[0]).addException((Type)((Object)IOException.class)).addCode(builder.build()).build();
    }

    private static final class CharacterRange {
        private final char lowerBound;
        private final char upperBound;

        private CharacterRange(char lowerBound, char upperBound) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        private String asCondition() {
            return "(currentCharacter >= '\\u" + this.toHexString(this.lowerBound) + "' && currentCharacter <= '\\u" + this.toHexString(this.upperBound) + "')";
        }

        private String toHexString(char character) {
            String hexValue = Integer.toHexString(character);
            return "0000".concat(hexValue).substring(hexValue.length());
        }

        private static CharacterRange of(char lowerBound, char upperBound) {
            return new CharacterRange(lowerBound, upperBound);
        }
    }
}

