/*
 * Decompiled with CFR 0.152.
 */
package io.codegen.jsobuilder.processor;

import io.codegen.jso-builder.processor.internal.$javapoet$.$AnnotationSpec;
import io.codegen.jso-builder.processor.internal.$javapoet$.$ClassName;
import io.codegen.jso-builder.processor.internal.$javapoet$.$CodeBlock;
import io.codegen.jso-builder.processor.internal.$javapoet$.$FieldSpec;
import io.codegen.jso-builder.processor.internal.$javapoet$.$JavaFile;
import io.codegen.jso-builder.processor.internal.$javapoet$.$MethodSpec;
import io.codegen.jso-builder.processor.internal.$javapoet$.$ParameterSpec;
import io.codegen.jso-builder.processor.internal.$javapoet$.$ParameterizedTypeName;
import io.codegen.jso-builder.processor.internal.$javapoet$.$TypeName;
import io.codegen.jso-builder.processor.internal.$javapoet$.$TypeSpec;
import io.codegen.jso-builder.processor.internal.$javapoet$.$WildcardTypeName;
import io.codegen.jsobuilder.processor.ClassNames;
import io.codegen.jsobuilder.processor.TypeMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public class JSOBuilderProcessor
extends AbstractProcessor {
    private final Set<String> processedClasses = new HashSet<String>();
    private Elements elementUtils = null;
    private Messager messager = null;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Arrays.asList(ClassNames.JSINTEROP_JSTYPE).stream().map($TypeName::toString).collect(Collectors.toSet());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<String> classesToProcess = this.collectClassNames(annotations, roundEnv);
        classesToProcess.stream().filter(name -> !this.processedClasses.contains(name)).map(name -> this.elementUtils.getTypeElement((CharSequence)name)).filter(this::isJsObject).forEach(this::generateBuilder);
        if (roundEnv.processingOver()) {
            this.processedClasses.clear();
        }
        return false;
    }

    private Set<String> collectClassNames(Set<? extends TypeElement> annotations, RoundEnvironment environment) {
        return annotations.stream().flatMap(annotation -> environment.getElementsAnnotatedWith((TypeElement)annotation).stream()).map(this::getClassName).collect(Collectors.toSet());
    }

    private String getClassName(Element element) {
        switch (element.getKind()) {
            case CLASS: {
                return element.asType().toString();
            }
        }
        this.emitError("Unkown element kind " + (Object)((Object)element.getKind()), element);
        return null;
    }

    private void emitError(String message, Element element) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    private void generateBuilder(TypeElement element) {
        $ClassName className = $ClassName.get(element);
        $ClassName builderName = className.peerClass(className.simpleName() + "JSOBuilder");
        $TypeSpec.Builder typeSpec = $TypeSpec.classBuilder(builderName).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT);
        typeSpec.addField(this.createObjectField(className));
        typeSpec.addMethod(this.createBuilderConstructor(className));
        typeSpec.addMethods(element.getEnclosedElements().stream().filter(type -> ElementKind.FIELD.equals((Object)type.getKind())).filter(type -> type.getAnnotationMirrors().stream().map(mirror -> $AnnotationSpec.get((AnnotationMirror)mirror).type).noneMatch(annotation -> annotation.equals(ClassNames.JSINTEROP_JSIGNORE) || annotation.equals(ClassNames.JSINTEROP_JSOVERLAY))).map(this::createPropertyMethod).collect(Collectors.toList()));
        typeSpec.addMethod(this.createBuildMethod(className));
        $JavaFile javaFile = $JavaFile.builder(builderName.packageName(), typeSpec.build()).skipJavaLangImports(true).build();
        try {
            javaFile.writeTo(this.processingEnv.getFiler());
        }
        catch (IOException e) {
            this.emitError("Unable to write file: " + e.getMessage(), element);
        }
    }

    private $FieldSpec createObjectField($ClassName className) {
        return $FieldSpec.builder(className, "object", Modifier.PRIVATE, Modifier.FINAL).build();
    }

    private $MethodSpec createBuilderConstructor($ClassName className) {
        $ParameterizedTypeName supplier = $ParameterizedTypeName.get($ClassName.get(Supplier.class), $WildcardTypeName.subtypeOf(className));
        return $MethodSpec.constructorBuilder().addModifiers(Modifier.PROTECTED).addParameter(supplier, "supplier", new Modifier[0]).addCode("object = supplier.get();\n", className).build();
    }

    private $MethodSpec createPropertyMethod(Element element) {
        return $MethodSpec.methodBuilder(this.getWithMethodName(element)).addModifiers(Modifier.PUBLIC).returns(this.getBuilderName(element.getEnclosingElement())).addParameter($ParameterSpec.builder($TypeName.get(element.asType()), element.getSimpleName().toString(), new Modifier[0]).build()).addCode($CodeBlock.builder().addStatement("object.$L = $L", element.getSimpleName(), element.getSimpleName()).addStatement("return this", new Object[0]).build()).build();
    }

    private $MethodSpec createBuildMethod($ClassName className) {
        return $MethodSpec.methodBuilder("build").addModifiers(Modifier.PUBLIC).returns(className).addCode($CodeBlock.builder().addStatement("return object", new Object[0]).build()).build();
    }

    private $ClassName getBuilderName(Element element) {
        $ClassName className = $ClassName.get(TypeMapper.asType(element));
        return className.peerClass(className.simpleName() + "JSOBuilder");
    }

    private String getWithMethodName(Element element) {
        String name = element.getSimpleName().toString();
        return "with" + Character.toUpperCase(name.charAt(0)) + name.substring(1, name.length());
    }

    private boolean isJsObject(TypeElement element) {
        return element.getAnnotationMirrors().stream().filter(mirror -> ClassNames.JSINTEROP_JSTYPE.equals($AnnotationSpec.get((AnnotationMirror)mirror).type)).anyMatch(mirror -> this.isNative((AnnotationMirror)mirror) && this.isInGlobalNamespace((AnnotationMirror)mirror) && this.isJsObject((AnnotationMirror)mirror));
    }

    private boolean isNative(AnnotationMirror mirror) {
        return mirror.getElementValues().entrySet().stream().filter(entry -> "isNative".equals(((ExecutableElement)entry.getKey()).getSimpleName().toString())).anyMatch(entry -> Boolean.TRUE.equals(((AnnotationValue)entry.getValue()).getValue()));
    }

    private boolean isInGlobalNamespace(AnnotationMirror mirror) {
        return mirror.getElementValues().entrySet().stream().filter(entry -> "namespace".equals(((ExecutableElement)entry.getKey()).getSimpleName().toString())).anyMatch(entry -> "<global>".equals(((AnnotationValue)entry.getValue()).getValue().toString()));
    }

    private boolean isJsObject(AnnotationMirror mirror) {
        return mirror.getElementValues().entrySet().stream().filter(entry -> "name".equals(((ExecutableElement)entry.getKey()).getSimpleName().toString())).anyMatch(entry -> "Object".equals(((AnnotationValue)entry.getValue()).getValue().toString()));
    }
}

