/*
 * Decompiled with CFR 0.152.
 */
package io.codegen.jsobuilder.integration;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.core.shared.GwtIncompatible;
import io.codegen.jsobuilder.integration.BasicJSO;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

public abstract class BasicJSOJSOBuilder {
    private final BasicJSO object = new BasicJSO();

    public BasicJSOJSOBuilder withStringProperty(String stringProperty) {
        this.object.stringProperty = stringProperty;
        return this;
    }

    public BasicJSOJSOBuilder withIntProperty(int intProperty) {
        this.object.intProperty = intProperty;
        return this;
    }

    public BasicJSOJSOBuilder withBooleanProperty(boolean booleanProperty) {
        this.object.booleanProperty = booleanProperty;
        return this;
    }

    public BasicJSOJSOBuilder withPropertyWithoutAnnotation(String propertyWithoutAnnotation) {
        this.object.propertyWithoutAnnotation = propertyWithoutAnnotation;
        return this;
    }

    public BasicJSOJSOBuilder withStringArrayProperty(String ... stringArrayProperty) {
        if (GWT.isClient()) {
            JsArray array;
            Object value;
            if (this.object.stringArrayProperty != null) {
                value = this.object.stringArrayProperty;
                array = (JsArray)value;
            } else {
                array = new JsArray();
                this.object.stringArrayProperty = value = array;
            }
            for (int i = 0; i < stringArrayProperty.length; ++i) {
                array.push(stringArrayProperty[i]);
            }
        } else {
            if (this.object.stringArrayProperty == null) {
                this.object.stringArrayProperty = new String[0];
            }
            this.object.stringArrayProperty = (String[])Stream.concat(Arrays.stream(this.object.stringArrayProperty), Arrays.stream(stringArrayProperty)).toArray(String[]::new);
        }
        return this;
    }

    public BasicJSO build() {
        BasicJSO result = new BasicJSO();
        result.booleanProperty = this.object.booleanProperty == Global.UNDEFINED_BOOLEAN ? false : this.object.booleanProperty;
        result.intProperty = this.object.intProperty == Global.UNDEFINED_INT ? 0 : this.object.intProperty;
        result.propertyWithoutAnnotation = this.object.propertyWithoutAnnotation == Global.UNDEFINED_OBJECT ? null : this.object.propertyWithoutAnnotation;
        result.stringArrayProperty = this.object.stringArrayProperty == Global.UNDEFINED_OBJECT ? null : this.object.stringArrayProperty;
        result.stringProperty = this.object.stringProperty == Global.UNDEFINED_OBJECT ? null : this.object.stringProperty;
        return result;
    }

    public static String toJSON(BasicJSO object) {
        if (GWT.isClient()) {
            return JSON.stringify(object);
        }
        JreSerializer serializer = new JreSerializer();
        return ((Serializer)serializer).toJSON(object);
    }

    static class JreSerializer
    extends Serializer {
        JreSerializer() {
        }

        @Override
        @GwtIncompatible
        final String toJSON(Object object) {
            if (!JreSerializer.isJsObject(object.getClass())) {
                throw new IllegalStateException("Class " + object.getClass() + " isn't a JavaScript object");
            }
            StringWriter writer = new StringWriter();
            try {
                JreSerializer.writeJSON(writer, object);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return writer.toString();
        }

        @GwtIncompatible
        private static final boolean isJsObject(Class<?> type) {
            JsType jsType = type.getAnnotation(JsType.class);
            if (jsType == null) {
                return false;
            }
            if (!jsType.isNative()) {
                return false;
            }
            if (!"<global>".equals(jsType.namespace())) {
                return false;
            }
            return "Object".equals(jsType.name());
        }

        @GwtIncompatible
        private static final void writeJSON(Writer writer, Object value) throws IOException {
            if (value == null) {
                writer.append("null");
                return;
            }
            Class<?> type = value.getClass();
            if (type.isPrimitive()) {
                writer.append(String.valueOf(value));
            } else if (type.isArray()) {
                writer.append('[');
                int arraySize = Array.getLength(value);
                for (int arrayIndex = 0; arrayIndex < arraySize; ++arrayIndex) {
                    JreSerializer.writeJSON(writer, Array.get(value, arrayIndex));
                    if (arrayIndex >= arraySize - 1) continue;
                    writer.append(',');
                }
                writer.append(']');
            } else if (Number.class.isAssignableFrom(type)) {
                writer.append(String.valueOf(value));
            } else if (Boolean.class.isAssignableFrom(type)) {
                writer.append(String.valueOf(value));
            } else if (CharSequence.class.isAssignableFrom(type)) {
                writer.append('\"');
                JreSerializer.writeValue(writer, String.valueOf(value));
                writer.append('\"');
            } else if (JreSerializer.isJsObject(type)) {
                writer.append('{');
                Field[] fields = type.getDeclaredFields();
                TreeMap<String, Field> fieldByName = new TreeMap<String, Field>();
                for (int fieldIndex = 0; fieldIndex < fields.length; ++fieldIndex) {
                    Field field = fields[fieldIndex];
                    if (field.getAnnotation(JsIgnore.class) != null || field.getAnnotation(JsOverlay.class) != null) continue;
                    JsProperty property = field.getAnnotation(JsProperty.class);
                    String name = property != null && !"<auto>".equals(property.name()) ? property.name() : field.getName();
                    fieldByName.put(name, field);
                }
                boolean firstProperty = true;
                for (Map.Entry entry : fieldByName.entrySet()) {
                    if (!firstProperty) {
                        writer.append(',');
                    }
                    writer.append('\"');
                    JreSerializer.writeValue(writer, (CharSequence)entry.getKey());
                    writer.append('\"');
                    writer.append(':');
                    try {
                        JreSerializer.writeJSON(writer, ((Field)entry.getValue()).get(value));
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    firstProperty = false;
                }
                writer.append('}');
            } else {
                throw new IllegalArgumentException("Unknown type " + type);
            }
        }

        @GwtIncompatible
        private static final void writeValue(Writer writer, CharSequence value) throws IOException {
            block9: for (int index = 0; index < value.length(); ++index) {
                char currentCharacter = value.charAt(index);
                switch (currentCharacter) {
                    case '\\': {
                        writer.write("\\\\");
                        continue block9;
                    }
                    case '\"': {
                        writer.write("\\\"");
                        continue block9;
                    }
                    case '\b': {
                        writer.write("\\b");
                        continue block9;
                    }
                    case '\t': {
                        writer.write("\\t");
                        continue block9;
                    }
                    case '\n': {
                        writer.write("\\n");
                        continue block9;
                    }
                    case '\f': {
                        writer.write("\\f");
                        continue block9;
                    }
                    case '\r': {
                        writer.write("\\r");
                        continue block9;
                    }
                    default: {
                        if (currentCharacter >= '\u0000' && currentCharacter <= '\u001f' || currentCharacter >= '\u007f' && currentCharacter <= '\u009f' || currentCharacter >= '\u2028' && currentCharacter <= '\u2029') {
                            writer.write("\\u");
                            String hexValue = Integer.toHexString(currentCharacter);
                            writer.write("0000", 0, 4 - hexValue.length());
                            writer.write(hexValue);
                            continue block9;
                        }
                        writer.write(currentCharacter);
                    }
                }
            }
        }
    }

    static class Serializer {
        Serializer() {
        }

        String toJSON(Object object) {
            return null;
        }
    }

    @JsType(isNative=true, namespace="<global>")
    static final class Global {
        @JsProperty(namespace="<global>", name="undefined")
        public static Object UNDEFINED_OBJECT;
        @JsProperty(namespace="<global>", name="undefined")
        public static boolean UNDEFINED_BOOLEAN;
        @JsProperty(namespace="<global>", name="undefined")
        public static byte UNDEFINED_BYTE;
        @JsProperty(namespace="<global>", name="undefined")
        public static char UNDEFINED_CHAR;
        @JsProperty(namespace="<global>", name="undefined")
        public static double UNDEFINED_DOUBLE;
        @JsProperty(namespace="<global>", name="undefined")
        public static float UNDEFINED_FLOAT;
        @JsProperty(namespace="<global>", name="undefined")
        public static int UNDEFINED_INT;
        @JsProperty(namespace="<global>", name="undefined")
        public static long UNDEFINED_LONG;
        @JsProperty(namespace="<global>", name="undefined")
        public static short UNDEFINED_SHORT;

        Global() {
        }
    }

    @JsType(isNative=true, namespace="<global>", name="JSON")
    static final class JSON {
        JSON() {
        }

        public static native String stringify(Object var0);
    }

    @JsType(isNative=true, namespace="<global>", name="Array")
    static final class JsArray<T> {
        JsArray() {
        }

        public native void push(T var1);
    }
}

