package io.codegen.gwt.jsonoverlay.processor.model.types;

import com.squareup.javapoet.ClassName;
import io.codegen.gwt.jsonoverlay.processor.model.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SubType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new SubType.Builder()}.
 */
@Generated(from = "SubType", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableSubType implements SubType {
  private final ClassName superType;
  private final ClassName subType;
  private final JavaType.Kind kind;

  private ImmutableSubType(
      ClassName superType,
      ClassName subType,
      JavaType.Kind kind) {
    this.superType = superType;
    this.subType = subType;
    this.kind = kind;
  }

  /**
   * @return The value of the {@code superType} attribute
   */
  @Override
  public ClassName getSuperType() {
    return superType;
  }

  /**
   * @return The value of the {@code subType} attribute
   */
  @Override
  public ClassName getSubType() {
    return subType;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public JavaType.Kind getKind() {
    return kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SubType#getSuperType() superType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for superType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSubType withSuperType(ClassName value) {
    if (this.superType == value) return this;
    ClassName newValue = Objects.requireNonNull(value, "superType");
    return new ImmutableSubType(newValue, this.subType, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SubType#getSubType() subType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for subType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSubType withSubType(ClassName value) {
    if (this.subType == value) return this;
    ClassName newValue = Objects.requireNonNull(value, "subType");
    return new ImmutableSubType(this.superType, newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SubType#getKind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSubType withKind(JavaType.Kind value) {
    if (this.kind == value) return this;
    JavaType.Kind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableSubType(this.superType, this.subType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSubType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSubType
        && equalTo((ImmutableSubType) another);
  }

  private boolean equalTo(ImmutableSubType another) {
    return superType.equals(another.superType)
        && subType.equals(another.subType)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code superType}, {@code subType}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + superType.hashCode();
    h += (h << 5) + subType.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SubType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SubType{"
        + "superType=" + superType
        + ", subType=" + subType
        + ", kind=" + kind
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SubType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SubType instance
   */
  public static ImmutableSubType copyOf(SubType instance) {
    if (instance instanceof ImmutableSubType) {
      return (ImmutableSubType) instance;
    }
    return new SubType.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableSubType ImmutableSubType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SubType", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_SUPER_TYPE = 0x1L;
    private static final long INIT_BIT_SUB_TYPE = 0x2L;
    private static final long INIT_BIT_KIND = 0x4L;
    private long initBits = 0x7L;

    private ClassName superType;
    private ClassName subType;
    private JavaType.Kind kind;

    /**
     * Creates a builder for {@link ImmutableSubType ImmutableSubType} instances.
     */
    public Builder() {
      if (!(this instanceof SubType.Builder)) {
        throw new UnsupportedOperationException("Use: new SubType.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.JavaType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final SubType.Builder from(JavaType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (SubType.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.types.SubType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final SubType.Builder from(SubType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (SubType.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof JavaType) {
        JavaType instance = (JavaType) object;
        kind(instance.getKind());
      }
      if (object instanceof SubType) {
        SubType instance = (SubType) object;
        superType(instance.getSuperType());
        subType(instance.getSubType());
      }
    }

    /**
     * Initializes the value for the {@link SubType#getSuperType() superType} attribute.
     * @param superType The value for superType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final SubType.Builder superType(ClassName superType) {
      this.superType = Objects.requireNonNull(superType, "superType");
      initBits &= ~INIT_BIT_SUPER_TYPE;
      return (SubType.Builder) this;
    }

    /**
     * Initializes the value for the {@link SubType#getSubType() subType} attribute.
     * @param subType The value for subType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final SubType.Builder subType(ClassName subType) {
      this.subType = Objects.requireNonNull(subType, "subType");
      initBits &= ~INIT_BIT_SUB_TYPE;
      return (SubType.Builder) this;
    }

    /**
     * Initializes the value for the {@link SubType#getKind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    public final SubType.Builder kind(JavaType.Kind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return (SubType.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableSubType ImmutableSubType}.
     * @return An immutable instance of SubType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSubType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSubType(superType, subType, kind);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SUPER_TYPE) != 0) attributes.add("superType");
      if ((initBits & INIT_BIT_SUB_TYPE) != 0) attributes.add("subType");
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build SubType, some of required attributes are not set " + attributes;
    }
  }
}
