package io.codegen.gwt.jsonoverlay.processor.model.types;

import com.squareup.javapoet.TypeName;
import io.codegen.gwt.jsonoverlay.processor.model.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StringType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new StringType.Builder()}.
 */
@Generated(from = "StringType", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableStringType implements StringType {
  private final TypeName stringType;
  private final JavaType.Kind kind;

  private ImmutableStringType(
      TypeName stringType,
      JavaType.Kind kind) {
    this.stringType = stringType;
    this.kind = kind;
  }

  /**
   * @return the type of the string, usually java.lang.String
   */
  @Override
  public TypeName getStringType() {
    return stringType;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public JavaType.Kind getKind() {
    return kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StringType#getStringType() stringType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stringType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStringType withStringType(TypeName value) {
    if (this.stringType == value) return this;
    TypeName newValue = Objects.requireNonNull(value, "stringType");
    return new ImmutableStringType(newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StringType#getKind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStringType withKind(JavaType.Kind value) {
    if (this.kind == value) return this;
    JavaType.Kind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableStringType(this.stringType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStringType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStringType
        && equalTo((ImmutableStringType) another);
  }

  private boolean equalTo(ImmutableStringType another) {
    return stringType.equals(another.stringType)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code stringType}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + stringType.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StringType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StringType{"
        + "stringType=" + stringType
        + ", kind=" + kind
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link StringType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StringType instance
   */
  public static ImmutableStringType copyOf(StringType instance) {
    if (instance instanceof ImmutableStringType) {
      return (ImmutableStringType) instance;
    }
    return new StringType.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableStringType ImmutableStringType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StringType", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_STRING_TYPE = 0x1L;
    private static final long INIT_BIT_KIND = 0x2L;
    private long initBits = 0x3L;

    private TypeName stringType;
    private JavaType.Kind kind;

    /**
     * Creates a builder for {@link ImmutableStringType ImmutableStringType} instances.
     */
    public Builder() {
      if (!(this instanceof StringType.Builder)) {
        throw new UnsupportedOperationException("Use: new StringType.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.JavaType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final StringType.Builder from(JavaType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (StringType.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.types.StringType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final StringType.Builder from(StringType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (StringType.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof JavaType) {
        JavaType instance = (JavaType) object;
        kind(instance.getKind());
      }
      if (object instanceof StringType) {
        StringType instance = (StringType) object;
        stringType(instance.getStringType());
      }
    }

    /**
     * Initializes the value for the {@link StringType#getStringType() stringType} attribute.
     * @param stringType The value for stringType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final StringType.Builder stringType(TypeName stringType) {
      this.stringType = Objects.requireNonNull(stringType, "stringType");
      initBits &= ~INIT_BIT_STRING_TYPE;
      return (StringType.Builder) this;
    }

    /**
     * Initializes the value for the {@link StringType#getKind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    public final StringType.Builder kind(JavaType.Kind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return (StringType.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableStringType ImmutableStringType}.
     * @return An immutable instance of StringType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStringType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStringType(stringType, kind);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STRING_TYPE) != 0) attributes.add("stringType");
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build StringType, some of required attributes are not set " + attributes;
    }
  }
}
