package io.codegen.gwt.jsonoverlay.processor.model.types;

import com.squareup.javapoet.TypeName;
import io.codegen.gwt.jsonoverlay.processor.model.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PrimitiveType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new PrimitiveType.Builder()}.
 */
@Generated(from = "PrimitiveType", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutablePrimitiveType
    implements PrimitiveType {
  private final TypeName primitiveType;
  private final JavaType.Kind kind;

  private ImmutablePrimitiveType(
      TypeName primitiveType,
      JavaType.Kind kind) {
    this.primitiveType = primitiveType;
    this.kind = kind;
  }

  /**
   * @return The value of the {@code primitiveType} attribute
   */
  @Override
  public TypeName getPrimitiveType() {
    return primitiveType;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public JavaType.Kind getKind() {
    return kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrimitiveType#getPrimitiveType() primitiveType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for primitiveType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrimitiveType withPrimitiveType(TypeName value) {
    if (this.primitiveType == value) return this;
    TypeName newValue = Objects.requireNonNull(value, "primitiveType");
    return new ImmutablePrimitiveType(newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PrimitiveType#getKind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePrimitiveType withKind(JavaType.Kind value) {
    if (this.kind == value) return this;
    JavaType.Kind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutablePrimitiveType(this.primitiveType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePrimitiveType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePrimitiveType
        && equalTo((ImmutablePrimitiveType) another);
  }

  private boolean equalTo(ImmutablePrimitiveType another) {
    return primitiveType.equals(another.primitiveType)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code primitiveType}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + primitiveType.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PrimitiveType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PrimitiveType{"
        + "primitiveType=" + primitiveType
        + ", kind=" + kind
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link PrimitiveType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PrimitiveType instance
   */
  public static ImmutablePrimitiveType copyOf(PrimitiveType instance) {
    if (instance instanceof ImmutablePrimitiveType) {
      return (ImmutablePrimitiveType) instance;
    }
    return new PrimitiveType.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutablePrimitiveType ImmutablePrimitiveType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PrimitiveType", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_PRIMITIVE_TYPE = 0x1L;
    private static final long INIT_BIT_KIND = 0x2L;
    private long initBits = 0x3L;

    private TypeName primitiveType;
    private JavaType.Kind kind;

    /**
     * Creates a builder for {@link ImmutablePrimitiveType ImmutablePrimitiveType} instances.
     */
    public Builder() {
      if (!(this instanceof PrimitiveType.Builder)) {
        throw new UnsupportedOperationException("Use: new PrimitiveType.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.JavaType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final PrimitiveType.Builder from(JavaType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (PrimitiveType.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.types.PrimitiveType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final PrimitiveType.Builder from(PrimitiveType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (PrimitiveType.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof JavaType) {
        JavaType instance = (JavaType) object;
        kind(instance.getKind());
      }
      if (object instanceof PrimitiveType) {
        PrimitiveType instance = (PrimitiveType) object;
        primitiveType(instance.getPrimitiveType());
      }
    }

    /**
     * Initializes the value for the {@link PrimitiveType#getPrimitiveType() primitiveType} attribute.
     * @param primitiveType The value for primitiveType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final PrimitiveType.Builder primitiveType(TypeName primitiveType) {
      this.primitiveType = Objects.requireNonNull(primitiveType, "primitiveType");
      initBits &= ~INIT_BIT_PRIMITIVE_TYPE;
      return (PrimitiveType.Builder) this;
    }

    /**
     * Initializes the value for the {@link PrimitiveType#getKind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    public final PrimitiveType.Builder kind(JavaType.Kind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return (PrimitiveType.Builder) this;
    }

    /**
     * Builds a new {@link ImmutablePrimitiveType ImmutablePrimitiveType}.
     * @return An immutable instance of PrimitiveType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePrimitiveType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePrimitiveType(primitiveType, kind);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PRIMITIVE_TYPE) != 0) attributes.add("primitiveType");
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build PrimitiveType, some of required attributes are not set " + attributes;
    }
  }
}
