package io.codegen.gwt.jsonoverlay.processor.model.types;

import com.squareup.javapoet.ClassName;
import io.codegen.gwt.jsonoverlay.processor.model.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OverlayType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new OverlayType.Builder()}.
 */
@Generated(from = "OverlayType", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableOverlayType
    implements OverlayType {
  private final ClassName overlayType;
  private final JavaType.Kind kind;

  private ImmutableOverlayType(
      ClassName overlayType,
      JavaType.Kind kind) {
    this.overlayType = overlayType;
    this.kind = kind;
  }

  /**
   * @return The value of the {@code overlayType} attribute
   */
  @Override
  public ClassName getOverlayType() {
    return overlayType;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public JavaType.Kind getKind() {
    return kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OverlayType#getOverlayType() overlayType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for overlayType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOverlayType withOverlayType(ClassName value) {
    if (this.overlayType == value) return this;
    ClassName newValue = Objects.requireNonNull(value, "overlayType");
    return new ImmutableOverlayType(newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OverlayType#getKind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOverlayType withKind(JavaType.Kind value) {
    if (this.kind == value) return this;
    JavaType.Kind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableOverlayType(this.overlayType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOverlayType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOverlayType
        && equalTo((ImmutableOverlayType) another);
  }

  private boolean equalTo(ImmutableOverlayType another) {
    return overlayType.equals(another.overlayType)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code overlayType}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + overlayType.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OverlayType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OverlayType{"
        + "overlayType=" + overlayType
        + ", kind=" + kind
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OverlayType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OverlayType instance
   */
  public static ImmutableOverlayType copyOf(OverlayType instance) {
    if (instance instanceof ImmutableOverlayType) {
      return (ImmutableOverlayType) instance;
    }
    return new OverlayType.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableOverlayType ImmutableOverlayType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OverlayType", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_OVERLAY_TYPE = 0x1L;
    private static final long INIT_BIT_KIND = 0x2L;
    private long initBits = 0x3L;

    private ClassName overlayType;
    private JavaType.Kind kind;

    /**
     * Creates a builder for {@link ImmutableOverlayType ImmutableOverlayType} instances.
     */
    public Builder() {
      if (!(this instanceof OverlayType.Builder)) {
        throw new UnsupportedOperationException("Use: new OverlayType.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.JavaType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final OverlayType.Builder from(JavaType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (OverlayType.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.types.OverlayType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final OverlayType.Builder from(OverlayType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (OverlayType.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof JavaType) {
        JavaType instance = (JavaType) object;
        kind(instance.getKind());
      }
      if (object instanceof OverlayType) {
        OverlayType instance = (OverlayType) object;
        overlayType(instance.getOverlayType());
      }
    }

    /**
     * Initializes the value for the {@link OverlayType#getOverlayType() overlayType} attribute.
     * @param overlayType The value for overlayType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final OverlayType.Builder overlayType(ClassName overlayType) {
      this.overlayType = Objects.requireNonNull(overlayType, "overlayType");
      initBits &= ~INIT_BIT_OVERLAY_TYPE;
      return (OverlayType.Builder) this;
    }

    /**
     * Initializes the value for the {@link OverlayType#getKind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    public final OverlayType.Builder kind(JavaType.Kind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return (OverlayType.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableOverlayType ImmutableOverlayType}.
     * @return An immutable instance of OverlayType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOverlayType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOverlayType(overlayType, kind);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_OVERLAY_TYPE) != 0) attributes.add("overlayType");
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build OverlayType, some of required attributes are not set " + attributes;
    }
  }
}
